/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.CharacterUtils;
import org.apache.lucene.util.Version;

public final class LowerCaseFilter
extends TokenFilter {
    private final CharacterUtils charUtils;
    private TermAttribute termAtt = this.addAttribute(TermAttribute.class);

    public LowerCaseFilter(Version matchVersion, TokenStream in) {
        super(in);
        this.charUtils = CharacterUtils.getInstance(matchVersion);
    }

    @Deprecated
    public LowerCaseFilter(TokenStream in) {
        this(Version.LUCENE_30, in);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.termBuffer();
            int length = this.termAtt.termLength();
            for (int i = 0; i < length; i += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(buffer, i)), buffer, i)) {
            }
            return true;
        }
        return false;
    }
}

