/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

public abstract class ReusableAnalyzerBase
extends Analyzer {
    protected abstract TokenStreamComponents createComponents(String var1, Reader var2);

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        TokenStreamComponents streamChain = (TokenStreamComponents)this.getPreviousTokenStream();
        if (streamChain == null || !streamChain.reset(reader)) {
            streamChain = this.createComponents(fieldName, reader);
            this.setPreviousTokenStream(streamChain);
        }
        return streamChain.getTokenStream();
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return this.createComponents(fieldName, reader).getTokenStream();
    }

    public static class TokenStreamComponents {
        final Tokenizer source;
        final TokenStream sink;

        public TokenStreamComponents(Tokenizer source, TokenStream result) {
            this.source = source;
            this.sink = result;
        }

        public TokenStreamComponents(Tokenizer source) {
            this.source = source;
            this.sink = source;
        }

        protected boolean reset(Reader reader) throws IOException {
            this.source.reset(reader);
            if (this.sink != this.source) {
                this.sink.reset();
            }
            return true;
        }

        protected TokenStream getTokenStream() {
            return this.sink;
        }
    }
}

