/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.io.IOException;
import java.text.Collator;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.IndexableBinaryStringTools;

public final class CollationKeyFilter
extends TokenFilter {
    private Collator collator = null;
    private TermAttribute termAtt;

    public CollationKeyFilter(TokenStream input, Collator collator) {
        super(input);
        this.collator = collator;
        this.termAtt = this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] termBuffer = this.termAtt.termBuffer();
            String termText = new String(termBuffer, 0, this.termAtt.termLength());
            byte[] collationKey = this.collator.getCollationKey(termText).toByteArray();
            int encodedLength = IndexableBinaryStringTools.getEncodedLength(collationKey, 0, collationKey.length);
            if (encodedLength > termBuffer.length) {
                this.termAtt.resizeTermBuffer(encodedLength);
            }
            this.termAtt.setTermLength(encodedLength);
            IndexableBinaryStringTools.encode(collationKey, 0, collationKey.length, this.termAtt.termBuffer(), 0, encodedLength);
            return true;
        }
        return false;
    }
}

