/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ThreadInterruptedException;

public class ConcurrentMergeScheduler
extends MergeScheduler {
    private int mergeThreadPriority = -1;
    protected List<MergeThread> mergeThreads = new ArrayList<MergeThread>();
    private int maxThreadCount = Math.max(1, Math.min(3, Runtime.getRuntime().availableProcessors() / 2));
    private int maxMergeCount = this.maxThreadCount + 2;
    protected Directory dir;
    private boolean closed;
    protected IndexWriter writer;
    protected int mergeThreadCount;
    static boolean anyExceptions = false;
    private boolean suppressExceptions;
    private static List<ConcurrentMergeScheduler> allInstances;

    public ConcurrentMergeScheduler() {
        if (allInstances != null) {
            this.addMyself();
        }
    }

    public void setMaxThreadCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count should be at least 1");
        }
        if (count > this.maxMergeCount) {
            throw new IllegalArgumentException("count should be <= maxMergeCount (= " + this.maxMergeCount + ")");
        }
        this.maxThreadCount = count;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxMergeCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count should be at least 1");
        }
        if (count < this.maxThreadCount) {
            throw new IllegalArgumentException("count should be >= maxThreadCount (= " + this.maxThreadCount + ")");
        }
        this.maxMergeCount = count;
    }

    public int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    public synchronized int getMergeThreadPriority() {
        this.initMergeThreadPriority();
        return this.mergeThreadPriority;
    }

    public synchronized void setMergeThreadPriority(int pri) {
        if (pri > 10 || pri < 1) {
            throw new IllegalArgumentException("priority must be in range 1 .. 10 inclusive");
        }
        this.mergeThreadPriority = pri;
        this.updateMergeThreads();
    }

    protected synchronized void updateMergeThreads() {
        Collections.sort(this.mergeThreads, new CompareByMergeDocCount());
        int count = this.mergeThreads.size();
        int pri = this.mergeThreadPriority;
        for (int i = 0; i < count; ++i) {
            MergeThread mergeThread = this.mergeThreads.get(i);
            MergePolicy.OneMerge merge = mergeThread.getCurrentMerge();
            if (merge == null) continue;
            boolean doPause = i < count - this.maxThreadCount;
            if (this.verbose() && doPause != merge.getPause()) {
                if (doPause) {
                    this.message("pause thread " + mergeThread.getName());
                } else {
                    this.message("unpause thread " + mergeThread.getName());
                }
            }
            if (doPause != merge.getPause()) {
                merge.setPause(doPause);
            }
            if (doPause) continue;
            if (this.verbose()) {
                this.message("set priority of merge thread " + mergeThread.getName() + " to " + pri);
            }
            mergeThread.setThreadPriority(pri);
            pri = Math.min(10, 1 + pri);
        }
    }

    private boolean verbose() {
        return this.writer != null && this.writer.verbose();
    }

    private void message(String message) {
        if (this.verbose()) {
            this.writer.message("CMS: " + message);
        }
    }

    private synchronized void initMergeThreadPriority() {
        if (this.mergeThreadPriority == -1) {
            this.mergeThreadPriority = 1 + Thread.currentThread().getPriority();
            if (this.mergeThreadPriority > 10) {
                this.mergeThreadPriority = 10;
            }
        }
    }

    public void close() {
        this.closed = true;
    }

    public synchronized void sync() {
        while (this.mergeThreadCount() > 0) {
            if (this.verbose()) {
                this.message("now wait for threads; currently " + this.mergeThreads.size() + " still running");
            }
            int count = this.mergeThreads.size();
            if (this.verbose()) {
                for (int i = 0; i < count; ++i) {
                    this.message("    " + i + ": " + this.mergeThreads.get(i));
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        }
    }

    private synchronized int mergeThreadCount() {
        int count = 0;
        int numThreads = this.mergeThreads.size();
        for (int i = 0; i < numThreads; ++i) {
            if (!this.mergeThreads.get(i).isAlive()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
        assert (!Thread.holdsLock(writer));
        this.writer = writer;
        this.initMergeThreadPriority();
        this.dir = writer.getDirectory();
        if (this.verbose()) {
            this.message("now merge");
            this.message("  index: " + writer.segString());
        }
        while (true) {
            Object var11_7;
            MergePolicy.OneMerge merge;
            if ((merge = writer.getNextMerge()) == null) {
                if (this.verbose()) {
                    this.message("  no more merges pending; now return");
                }
                return;
            }
            writer.mergeInit(merge);
            boolean success = false;
            try {
                ConcurrentMergeScheduler concurrentMergeScheduler = this;
                synchronized (concurrentMergeScheduler) {
                    long startStallTime = 0L;
                    while (this.mergeThreadCount() >= this.maxMergeCount) {
                        startStallTime = System.currentTimeMillis();
                        if (this.verbose()) {
                            this.message("    too many merges; stalling...");
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            throw new ThreadInterruptedException(ie);
                        }
                    }
                    if (this.verbose()) {
                        if (startStallTime != 0L) {
                            this.message("  stalled for " + (System.currentTimeMillis() - startStallTime) + " msec");
                        }
                        this.message("  consider merge " + merge.segString(this.dir));
                    }
                    assert (this.mergeThreadCount() < this.maxMergeCount);
                    MergeThread merger = this.getMergeThread(writer, merge);
                    this.mergeThreads.add(merger);
                    this.updateMergeThreads();
                    if (this.verbose()) {
                        this.message("    launch new thread [" + merger.getName() + "]");
                    }
                    merger.start();
                    success = true;
                }
                var11_7 = null;
                if (success) continue;
            }
            catch (Throwable throwable) {
                var11_7 = null;
                if (!success) {
                    writer.mergeFinish(merge);
                }
                throw throwable;
            }
            writer.mergeFinish(merge);
        }
    }

    protected void doMerge(MergePolicy.OneMerge merge) throws IOException {
        this.writer.merge(merge);
    }

    protected synchronized MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
        MergeThread thread = new MergeThread(writer, merge);
        thread.setThreadPriority(this.mergeThreadPriority);
        thread.setDaemon(true);
        thread.setName("Lucene Merge Thread #" + this.mergeThreadCount++);
        return thread;
    }

    protected void handleMergeException(Throwable exc) {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
        throw new MergePolicy.MergeException(exc, this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean anyUnhandledExceptions() {
        if (allInstances == null) {
            throw new RuntimeException("setTestMode() was not called; often this is because your test case's setUp method fails to call super.setUp in LuceneTestCase");
        }
        List<ConcurrentMergeScheduler> list = allInstances;
        synchronized (list) {
            int count = allInstances.size();
            for (int i = 0; i < count; ++i) {
                allInstances.get(i).sync();
            }
            boolean v = anyExceptions;
            anyExceptions = false;
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearUnhandledExceptions() {
        List<ConcurrentMergeScheduler> list = allInstances;
        synchronized (list) {
            anyExceptions = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMyself() {
        List<ConcurrentMergeScheduler> list = allInstances;
        synchronized (list) {
            int size = allInstances.size();
            int upto = 0;
            for (int i = 0; i < size; ++i) {
                ConcurrentMergeScheduler other = allInstances.get(i);
                if (other.closed && 0 == other.mergeThreadCount()) continue;
                allInstances.set(upto++, other);
            }
            allInstances.subList(upto, allInstances.size()).clear();
            allInstances.add(this);
        }
    }

    void setSuppressExceptions() {
        this.suppressExceptions = true;
    }

    void clearSuppressExceptions() {
        this.suppressExceptions = false;
    }

    public static void setTestMode() {
        allInstances = new ArrayList<ConcurrentMergeScheduler>();
    }

    protected class MergeThread
    extends Thread {
        IndexWriter writer;
        MergePolicy.OneMerge startMerge;
        MergePolicy.OneMerge runningMerge;
        private volatile boolean done;

        public MergeThread(IndexWriter writer, MergePolicy.OneMerge startMerge) throws IOException {
            this.writer = writer;
            this.startMerge = startMerge;
        }

        public synchronized void setRunningMerge(MergePolicy.OneMerge merge) {
            this.runningMerge = merge;
        }

        public synchronized MergePolicy.OneMerge getRunningMerge() {
            return this.runningMerge;
        }

        public synchronized MergePolicy.OneMerge getCurrentMerge() {
            if (this.done) {
                return null;
            }
            if (this.runningMerge != null) {
                return this.runningMerge;
            }
            return this.startMerge;
        }

        public void setThreadPriority(int pri) {
            try {
                this.setPriority(pri);
            }
            catch (NullPointerException npe) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            MergePolicy.OneMerge merge = this.startMerge;
            try {
                block14: {
                    try {
                        if (ConcurrentMergeScheduler.this.verbose()) {
                            ConcurrentMergeScheduler.this.message("  merge thread: start");
                        }
                        while (true) {
                            this.setRunningMerge(merge);
                            ConcurrentMergeScheduler.this.doMerge(merge);
                            merge = this.writer.getNextMerge();
                            if (merge == null) break;
                            this.writer.mergeInit(merge);
                            ConcurrentMergeScheduler.this.updateMergeThreads();
                            if (!ConcurrentMergeScheduler.this.verbose()) continue;
                            ConcurrentMergeScheduler.this.message("  merge thread: do another merge " + merge.segString(ConcurrentMergeScheduler.this.dir));
                        }
                        this.done = true;
                        ConcurrentMergeScheduler.this.updateMergeThreads();
                        if (!ConcurrentMergeScheduler.this.verbose()) break block14;
                        ConcurrentMergeScheduler.this.message("  merge thread: done");
                    }
                    catch (Throwable exc) {
                        if (!(exc instanceof MergePolicy.MergeAbortedException) && !ConcurrentMergeScheduler.this.suppressExceptions) {
                            anyExceptions = true;
                            ConcurrentMergeScheduler.this.handleMergeException(exc);
                        }
                        Object var4_3 = null;
                        ConcurrentMergeScheduler concurrentMergeScheduler3 = ConcurrentMergeScheduler.this;
                        synchronized (concurrentMergeScheduler3) {
                            ConcurrentMergeScheduler.this.notifyAll();
                            boolean removed = ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                            assert (removed);
                            ConcurrentMergeScheduler.this.updateMergeThreads();
                            return;
                        }
                    }
                }
                Object var4_2 = null;
                ConcurrentMergeScheduler concurrentMergeScheduler = ConcurrentMergeScheduler.this;
                synchronized (concurrentMergeScheduler) {
                    ConcurrentMergeScheduler.this.notifyAll();
                    boolean removed = ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                    assert (removed);
                    ConcurrentMergeScheduler.this.updateMergeThreads();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ConcurrentMergeScheduler concurrentMergeScheduler2 = ConcurrentMergeScheduler.this;
                synchronized (concurrentMergeScheduler2) {
                    ConcurrentMergeScheduler.this.notifyAll();
                    boolean removed = ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                    assert (removed);
                    ConcurrentMergeScheduler.this.updateMergeThreads();
                    throw throwable;
                }
            }
        }

        public String toString() {
            MergePolicy.OneMerge merge = this.getRunningMerge();
            if (merge == null) {
                merge = this.startMerge;
            }
            return "merge thread: " + merge.segString(ConcurrentMergeScheduler.this.dir);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CompareByMergeDocCount
    implements Comparator<MergeThread> {
        protected CompareByMergeDocCount() {
        }

        @Override
        public int compare(MergeThread t1, MergeThread t2) {
            MergePolicy.OneMerge m1 = t1.getCurrentMerge();
            MergePolicy.OneMerge m2 = t2.getCurrentMerge();
            int c1 = m1 == null ? Integer.MAX_VALUE : m1.segments.totalDocCount();
            int c2 = m2 == null ? Integer.MAX_VALUE : m2.segments.totalDocCount();
            return c2 - c1;
        }
    }
}

