/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumersPerField;
import org.apache.lucene.index.DocFieldConsumersPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocFieldConsumers
extends DocFieldConsumer {
    final DocFieldConsumer one;
    final DocFieldConsumer two;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    int allocCount;

    public DocFieldConsumers(DocFieldConsumer one, DocFieldConsumer two) {
        this.one = one;
        this.two = two;
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.one.setFieldInfos(fieldInfos);
        this.two.setFieldInfos(fieldInfos);
    }

    @Override
    public void flush(Map<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> oneThreadsAndFields = new HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>>();
        HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> twoThreadsAndFields = new HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>>();
        for (Map.Entry<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> entry : threadsAndFields.entrySet()) {
            DocFieldConsumersPerThread perThread = (DocFieldConsumersPerThread)entry.getKey();
            Collection<DocFieldConsumerPerField> fields = entry.getValue();
            Iterator<DocFieldConsumerPerField> fieldsIt = fields.iterator();
            HashSet<DocFieldConsumerPerField> oneFields = new HashSet<DocFieldConsumerPerField>();
            HashSet<DocFieldConsumerPerField> twoFields = new HashSet<DocFieldConsumerPerField>();
            while (fieldsIt.hasNext()) {
                DocFieldConsumersPerField perField = (DocFieldConsumersPerField)fieldsIt.next();
                oneFields.add(perField.one);
                twoFields.add(perField.two);
            }
            oneThreadsAndFields.put(perThread.one, oneFields);
            twoThreadsAndFields.put(perThread.two, twoFields);
        }
        this.one.flush(oneThreadsAndFields, state);
        this.two.flush(twoThreadsAndFields, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeDocStore(SegmentWriteState state) throws IOException {
        try {
            this.one.closeDocStore(state);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.two.closeDocStore(state);
            throw throwable;
        }
        this.two.closeDocStore(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            this.one.abort();
            Object var2_1 = null;
            this.two.abort();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.two.abort();
            throw throwable;
        }
    }

    @Override
    public boolean freeRAM() {
        boolean any = this.one.freeRAM();
        return any |= this.two.freeRAM();
    }

    @Override
    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) throws IOException {
        return new DocFieldConsumersPerThread(docFieldProcessorPerThread, this, this.one.addThread(docFieldProcessorPerThread), this.two.addThread(docFieldProcessorPerThread));
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.oversize(this.allocCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    synchronized void freePerDoc(PerDoc perDoc) {
        assert (this.freeCount < this.docFreeList.length);
        this.docFreeList[this.freeCount++] = perDoc;
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        DocumentsWriter.DocWriter one;
        DocumentsWriter.DocWriter two;

        PerDoc() {
        }

        public long sizeInBytes() {
            return this.one.sizeInBytes() + this.two.sizeInBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() throws IOException {
            try {
                try {
                    this.one.finish();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.two.finish();
                    throw throwable;
                }
                this.two.finish();
                Object var4_4 = null;
                DocFieldConsumers.this.freePerDoc(this);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DocFieldConsumers.this.freePerDoc(this);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            try {
                try {
                    this.one.abort();
                    Object var2_1 = null;
                    this.two.abort();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.two.abort();
                    throw throwable;
                }
                Object var4_4 = null;
                DocFieldConsumers.this.freePerDoc(this);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DocFieldConsumers.this.freePerDoc(this);
                throw throwable;
            }
        }
    }
}

