/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessor;
import org.apache.lucene.index.DocFieldProcessorPerField;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsWriterPerThread;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocFieldProcessorPerThread
extends DocConsumerPerThread {
    float docBoost;
    int fieldGen;
    final DocFieldProcessor docFieldProcessor;
    final FieldInfos fieldInfos;
    final DocFieldConsumerPerThread consumer;
    DocFieldProcessorPerField[] fields = new DocFieldProcessorPerField[1];
    int fieldCount;
    DocFieldProcessorPerField[] fieldHash = new DocFieldProcessorPerField[2];
    int hashMask = 1;
    int totalFieldCount;
    final StoredFieldsWriterPerThread fieldsWriter;
    final DocumentsWriter.DocState docState;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    int allocCount;

    public DocFieldProcessorPerThread(DocumentsWriterThreadState threadState, DocFieldProcessor docFieldProcessor) throws IOException {
        this.docState = threadState.docState;
        this.docFieldProcessor = docFieldProcessor;
        this.fieldInfos = docFieldProcessor.fieldInfos;
        this.consumer = docFieldProcessor.consumer.addThread(this);
        this.fieldsWriter = docFieldProcessor.fieldsWriter.addThread(this.docState);
    }

    @Override
    public void abort() {
        for (int i = 0; i < this.fieldHash.length; ++i) {
            DocFieldProcessorPerField field = this.fieldHash[i];
            while (field != null) {
                DocFieldProcessorPerField next = field.next;
                field.abort();
                field = next;
            }
        }
        this.fieldsWriter.abort();
        this.consumer.abort();
    }

    public Collection<DocFieldConsumerPerField> fields() {
        HashSet<DocFieldConsumerPerField> fields = new HashSet<DocFieldConsumerPerField>();
        for (int i = 0; i < this.fieldHash.length; ++i) {
            DocFieldProcessorPerField field = this.fieldHash[i];
            while (field != null) {
                fields.add(field.consumer);
                field = field.next;
            }
        }
        assert (fields.size() == this.totalFieldCount);
        return fields;
    }

    void trimFields(SegmentWriteState state) {
        for (int i = 0; i < this.fieldHash.length; ++i) {
            DocFieldProcessorPerField perField = this.fieldHash[i];
            DocFieldProcessorPerField lastPerField = null;
            while (perField != null) {
                if (perField.lastGen == -1) {
                    if (lastPerField == null) {
                        this.fieldHash[i] = perField.next;
                    } else {
                        lastPerField.next = perField.next;
                    }
                    if (state.docWriter.infoStream != null) {
                        state.docWriter.infoStream.println("  purge field=" + perField.fieldInfo.name);
                    }
                    --this.totalFieldCount;
                } else {
                    perField.lastGen = -1;
                    lastPerField = perField;
                }
                perField = perField.next;
            }
        }
    }

    private void rehash() {
        int newHashSize = this.fieldHash.length * 2;
        assert (newHashSize > this.fieldHash.length);
        DocFieldProcessorPerField[] newHashArray = new DocFieldProcessorPerField[newHashSize];
        int newHashMask = newHashSize - 1;
        for (int j = 0; j < this.fieldHash.length; ++j) {
            DocFieldProcessorPerField fp0 = this.fieldHash[j];
            while (fp0 != null) {
                int hashPos2 = fp0.fieldInfo.name.hashCode() & newHashMask;
                DocFieldProcessorPerField nextFP0 = fp0.next;
                fp0.next = newHashArray[hashPos2];
                newHashArray[hashPos2] = fp0;
                fp0 = nextFP0;
            }
        }
        this.fieldHash = newHashArray;
        this.hashMask = newHashMask;
    }

    @Override
    public DocumentsWriter.DocWriter processDocument() throws IOException {
        int i;
        this.consumer.startDocument();
        this.fieldsWriter.startDocument();
        Document doc = this.docState.doc;
        assert (this.docFieldProcessor.docWriter.writer.testPoint("DocumentsWriter.ThreadState.init start"));
        this.fieldCount = 0;
        int thisFieldGen = this.fieldGen++;
        List<Fieldable> docFields = doc.getFields();
        int numDocFields = docFields.size();
        for (i = 0; i < numDocFields; ++i) {
            Fieldable field = docFields.get(i);
            String fieldName = field.name();
            int hashPos = fieldName.hashCode() & this.hashMask;
            DocFieldProcessorPerField fp = this.fieldHash[hashPos];
            while (fp != null && !fp.fieldInfo.name.equals(fieldName)) {
                fp = fp.next;
            }
            if (fp == null) {
                FieldInfo fi = this.fieldInfos.add(fieldName, field.isIndexed(), field.isTermVectorStored(), field.isStorePositionWithTermVector(), field.isStoreOffsetWithTermVector(), field.getOmitNorms(), false, field.getOmitTermFreqAndPositions());
                fp = new DocFieldProcessorPerField(this, fi);
                fp.next = this.fieldHash[hashPos];
                this.fieldHash[hashPos] = fp;
                ++this.totalFieldCount;
                if (this.totalFieldCount >= this.fieldHash.length / 2) {
                    this.rehash();
                }
            } else {
                fp.fieldInfo.update(field.isIndexed(), field.isTermVectorStored(), field.isStorePositionWithTermVector(), field.isStoreOffsetWithTermVector(), field.getOmitNorms(), false, field.getOmitTermFreqAndPositions());
            }
            if (thisFieldGen != fp.lastGen) {
                fp.fieldCount = 0;
                if (this.fieldCount == this.fields.length) {
                    int newSize = this.fields.length * 2;
                    DocFieldProcessorPerField[] newArray = new DocFieldProcessorPerField[newSize];
                    System.arraycopy(this.fields, 0, newArray, 0, this.fieldCount);
                    this.fields = newArray;
                }
                this.fields[this.fieldCount++] = fp;
                fp.lastGen = thisFieldGen;
            }
            if (fp.fieldCount == fp.fields.length) {
                Fieldable[] newArray = new Fieldable[fp.fields.length * 2];
                System.arraycopy(fp.fields, 0, newArray, 0, fp.fieldCount);
                fp.fields = newArray;
            }
            fp.fields[fp.fieldCount++] = field;
            if (!field.isStored()) continue;
            this.fieldsWriter.addField(field, fp.fieldInfo);
        }
        this.quickSort(this.fields, 0, this.fieldCount - 1);
        for (i = 0; i < this.fieldCount; ++i) {
            this.fields[i].consumer.processFields(this.fields[i].fields, this.fields[i].fieldCount);
        }
        if (this.docState.maxTermPrefix != null && this.docState.infoStream != null) {
            this.docState.infoStream.println("WARNING: document contains at least one immense term (longer than the max length 16383), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + this.docState.maxTermPrefix + "...'");
            this.docState.maxTermPrefix = null;
        }
        DocumentsWriter.DocWriter one = this.fieldsWriter.finishDocument();
        DocumentsWriter.DocWriter two = this.consumer.finishDocument();
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        PerDoc both = this.getPerDoc();
        both.docID = this.docState.docID;
        assert (one.docID == this.docState.docID);
        assert (two.docID == this.docState.docID);
        both.one = one;
        both.two = two;
        return both;
    }

    void quickSort(DocFieldProcessorPerField[] array, int lo, int hi) {
        int right;
        int left;
        DocFieldProcessorPerField tmp;
        if (lo >= hi) {
            return;
        }
        if (hi == 1 + lo) {
            if (array[lo].fieldInfo.name.compareTo(array[hi].fieldInfo.name) > 0) {
                DocFieldProcessorPerField tmp2 = array[lo];
                array[lo] = array[hi];
                array[hi] = tmp2;
            }
            return;
        }
        int mid = lo + hi >>> 1;
        if (array[lo].fieldInfo.name.compareTo(array[mid].fieldInfo.name) > 0) {
            tmp = array[lo];
            array[lo] = array[mid];
            array[mid] = tmp;
        }
        if (array[mid].fieldInfo.name.compareTo(array[hi].fieldInfo.name) > 0) {
            tmp = array[mid];
            array[mid] = array[hi];
            array[hi] = tmp;
            if (array[lo].fieldInfo.name.compareTo(array[mid].fieldInfo.name) > 0) {
                DocFieldProcessorPerField tmp2 = array[lo];
                array[lo] = array[mid];
                array[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        DocFieldProcessorPerField partition = array[mid];
        while (true) {
            if (array[right].fieldInfo.name.compareTo(partition.fieldInfo.name) > 0) {
                --right;
                continue;
            }
            while (left < right && array[left].fieldInfo.name.compareTo(partition.fieldInfo.name) <= 0) {
                ++left;
            }
            if (left >= right) break;
            DocFieldProcessorPerField tmp3 = array[left];
            array[left] = array[right];
            array[right] = tmp3;
            --right;
        }
        this.quickSort(array, lo, left);
        this.quickSort(array, left + 1, hi);
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.oversize(this.allocCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    synchronized void freePerDoc(PerDoc perDoc) {
        assert (this.freeCount < this.docFreeList.length);
        this.docFreeList[this.freeCount++] = perDoc;
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        DocumentsWriter.DocWriter one;
        DocumentsWriter.DocWriter two;

        PerDoc() {
        }

        public long sizeInBytes() {
            return this.one.sizeInBytes() + this.two.sizeInBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() throws IOException {
            try {
                try {
                    this.one.finish();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.two.finish();
                    throw throwable;
                }
                this.two.finish();
                Object var4_4 = null;
                DocFieldProcessorPerThread.this.freePerDoc(this);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DocFieldProcessorPerThread.this.freePerDoc(this);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            try {
                try {
                    this.one.abort();
                    Object var2_1 = null;
                    this.two.abort();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.two.abort();
                    throw throwable;
                }
                Object var4_4 = null;
                DocFieldProcessorPerThread.this.freePerDoc(this);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DocFieldProcessorPerThread.this.freePerDoc(this);
                throw throwable;
            }
        }
    }
}

