/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;

final class DocInverterPerField
extends DocFieldConsumerPerField {
    private final DocInverterPerThread perThread;
    private final FieldInfo fieldInfo;
    final InvertedDocConsumerPerField consumer;
    final InvertedDocEndConsumerPerField endConsumer;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;

    public DocInverterPerField(DocInverterPerThread perThread, FieldInfo fieldInfo) {
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = perThread.docState;
        this.fieldState = perThread.fieldState;
        this.consumer = perThread.consumer.addField(this, fieldInfo);
        this.endConsumer = perThread.endConsumer.addField(this, fieldInfo);
    }

    void abort() {
        this.consumer.abort();
        this.endConsumer.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFields(Fieldable[] fields, int count) throws IOException {
        this.fieldState.reset(this.docState.doc.getBoost());
        int maxFieldLength = this.docState.maxFieldLength;
        boolean doInvert = this.consumer.start(fields, count);
        for (int i = 0; i < count; ++i) {
            boolean anyToken;
            Fieldable field = fields[i];
            if (!field.isIndexed() || !doInvert) continue;
            if (this.fieldState.length > 0) {
                this.fieldState.position += this.docState.analyzer.getPositionIncrementGap(this.fieldInfo.name);
            }
            if (!field.isTokenized()) {
                Object var12_17;
                String stringValue = field.stringValue();
                int valueLength = stringValue.length();
                this.perThread.singleToken.reinit(stringValue, 0, valueLength);
                this.fieldState.attributeSource = this.perThread.singleToken;
                this.consumer.start(field);
                boolean success = false;
                try {
                    this.consumer.add();
                    success = true;
                    var12_17 = null;
                    if (!success) {
                        this.docState.docWriter.setAborting();
                    }
                }
                catch (Throwable throwable) {
                    var12_17 = null;
                    if (!success) {
                        this.docState.docWriter.setAborting();
                    }
                    throw throwable;
                }
                this.fieldState.offset += valueLength;
                ++this.fieldState.length;
                ++this.fieldState.position;
                anyToken = valueLength > 0;
            } else {
                Object var19_22;
                TokenStream stream;
                TokenStream streamValue = field.tokenStreamValue();
                if (streamValue != null) {
                    stream = streamValue;
                } else {
                    Reader reader;
                    Reader readerValue = field.readerValue();
                    if (readerValue != null) {
                        reader = readerValue;
                    } else {
                        String stringValue = field.stringValue();
                        if (stringValue == null) {
                            throw new IllegalArgumentException("field must have either TokenStream, String or Reader value");
                        }
                        this.perThread.stringReader.init(stringValue);
                        reader = this.perThread.stringReader;
                    }
                    stream = this.docState.analyzer.reusableTokenStream(this.fieldInfo.name, reader);
                }
                stream.reset();
                int startLength = this.fieldState.length;
                try {
                    boolean hasMoreTokens = stream.incrementToken();
                    this.fieldState.attributeSource = stream;
                    OffsetAttribute offsetAttribute = this.fieldState.attributeSource.addAttribute(OffsetAttribute.class);
                    PositionIncrementAttribute posIncrAttribute = this.fieldState.attributeSource.addAttribute(PositionIncrementAttribute.class);
                    this.consumer.start(field);
                    while (hasMoreTokens) {
                        Object var17_21;
                        int posIncr = posIncrAttribute.getPositionIncrement();
                        this.fieldState.position += posIncr;
                        if (this.fieldState.position > 0) {
                            --this.fieldState.position;
                        }
                        if (posIncr == 0) {
                            ++this.fieldState.numOverlap;
                        }
                        boolean success = false;
                        try {
                            this.consumer.add();
                            success = true;
                            var17_21 = null;
                            if (!success) {
                                this.docState.docWriter.setAborting();
                            }
                        }
                        catch (Throwable throwable) {
                            var17_21 = null;
                            if (!success) {
                                this.docState.docWriter.setAborting();
                            }
                            throw throwable;
                        }
                        ++this.fieldState.position;
                        if (++this.fieldState.length >= maxFieldLength) {
                            if (this.docState.infoStream == null) break;
                            this.docState.infoStream.println("maxFieldLength " + maxFieldLength + " reached for field " + this.fieldInfo.name + ", ignoring following tokens");
                            break;
                        }
                        hasMoreTokens = stream.incrementToken();
                    }
                    stream.end();
                    this.fieldState.offset += offsetAttribute.endOffset();
                    anyToken = this.fieldState.length > startLength;
                    var19_22 = null;
                }
                catch (Throwable throwable) {
                    var19_22 = null;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                {
                }
            }
            if (anyToken) {
                this.fieldState.offset += this.docState.analyzer.getOffsetGap(field);
            }
            this.fieldState.boost *= field.getBoost();
        }
        this.consumer.finish();
        this.endConsumer.finish();
    }
}

