/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;

public abstract class MultiTermQuery
extends Query {
    protected RewriteMethod rewriteMethod = CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    transient int numberOfTerms = 0;
    public static final RewriteMethod CONSTANT_SCORE_FILTER_REWRITE = new ConstantScoreFilterRewrite();
    public static final RewriteMethod SCORING_BOOLEAN_QUERY_REWRITE = new ScoringBooleanQueryRewrite();
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = new ConstantScoreBooleanQueryRewrite();
    public static final RewriteMethod CONSTANT_SCORE_AUTO_REWRITE_DEFAULT = new ConstantScoreAutoRewrite(){

        public void setTermCountCutoff(int count) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        public void setDocCountPercent(double percent) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
        }
    };

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    public int getTotalNumberOfTerms() {
        return this.numberOfTerms;
    }

    public void clearTotalNumberOfTerms() {
        this.numberOfTerms = 0;
    }

    protected void incTotalNumberOfTerms(int inc) {
        this.numberOfTerms += inc;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this.rewriteMethod.rewrite(reader, this);
    }

    public RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    public void setRewriteMethod(RewriteMethod method) {
        this.rewriteMethod = method;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        result = 31 * result;
        return result += this.rewriteMethod.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTermQuery other = (MultiTermQuery)obj;
        if (Float.floatToIntBits(this.getBoost()) != Float.floatToIntBits(other.getBoost())) {
            return false;
        }
        return this.rewriteMethod.equals(other.rewriteMethod);
    }

    public static class ConstantScoreAutoRewrite
    extends BooleanQueryRewrite {
        public static int DEFAULT_TERM_COUNT_CUTOFF = 350;
        public static double DEFAULT_DOC_COUNT_PERCENT = 0.1;
        private int termCountCutoff = DEFAULT_TERM_COUNT_CUTOFF;
        private double docCountPercent = DEFAULT_DOC_COUNT_PERCENT;

        public void setTermCountCutoff(int count) {
            this.termCountCutoff = count;
        }

        public int getTermCountCutoff() {
            return this.termCountCutoff;
        }

        public void setDocCountPercent(double percent) {
            this.docCountPercent = percent;
        }

        public double getDocCountPercent() {
            return this.docCountPercent;
        }

        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            Query result;
            int docCountCutoff = (int)(this.docCountPercent / 100.0 * (double)reader.maxDoc());
            int termCountLimit = Math.min(BooleanQuery.getMaxClauseCount(), this.termCountCutoff);
            CutOffTermCollector col = new CutOffTermCollector(reader, docCountCutoff, termCountLimit);
            this.collectTerms(reader, query, col);
            if (col.hasCutOff) {
                return CONSTANT_SCORE_FILTER_REWRITE.rewrite(reader, query);
            }
            if (col.pendingTerms.isEmpty()) {
                result = new BooleanQuery(true);
            } else {
                BooleanQuery bq = new BooleanQuery(true);
                for (Term term : col.pendingTerms) {
                    TermQuery tq = new TermQuery(term);
                    bq.add(tq, BooleanClause.Occur.SHOULD);
                }
                result = new ConstantScoreQuery(new QueryWrapperFilter(bq));
                result.setBoost(query.getBoost());
            }
            query.incTotalNumberOfTerms(col.pendingTerms.size());
            return result;
        }

        public int hashCode() {
            int prime = 1279;
            return (int)((long)(1279 * this.termCountCutoff) + Double.doubleToLongBits(this.docCountPercent));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstantScoreAutoRewrite other = (ConstantScoreAutoRewrite)obj;
            if (other.termCountCutoff != this.termCountCutoff) {
                return false;
            }
            return Double.doubleToLongBits(other.docCountPercent) == Double.doubleToLongBits(this.docCountPercent);
        }

        private static final class CutOffTermCollector
        implements BooleanQueryRewrite.TermCollector {
            int docVisitCount = 0;
            boolean hasCutOff = false;
            final IndexReader reader;
            final int docCountCutoff;
            final int termCountLimit;
            final ArrayList<Term> pendingTerms = new ArrayList();

            CutOffTermCollector(IndexReader reader, int docCountCutoff, int termCountLimit) {
                this.reader = reader;
                this.docCountCutoff = docCountCutoff;
                this.termCountLimit = termCountLimit;
            }

            public boolean collect(Term t, float boost) throws IOException {
                this.pendingTerms.add(t);
                if (this.pendingTerms.size() >= this.termCountLimit || this.docVisitCount >= this.docCountCutoff) {
                    this.hasCutOff = true;
                    return false;
                }
                this.docVisitCount += this.reader.docFreq(t);
                return true;
            }
        }
    }

    private static class ConstantScoreBooleanQueryRewrite
    extends ScoringBooleanQueryRewrite
    implements Serializable {
        private ConstantScoreBooleanQueryRewrite() {
        }

        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            Query result = super.rewrite(reader, query);
            assert (result instanceof BooleanQuery);
            if (!((BooleanQuery)result).clauses().isEmpty()) {
                result = new ConstantScoreQuery(new QueryWrapperFilter(result));
                result.setBoost(query.getBoost());
            }
            return result;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;
        }
    }

    public static final class TopTermsScoringBooleanQueryRewrite
    extends BooleanQueryRewrite {
        private final int size;

        public TopTermsScoringBooleanQueryRewrite(int size) {
            this.size = size;
        }

        public TopTermsScoringBooleanQueryRewrite() {
            this(Integer.MAX_VALUE);
        }

        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            final int maxSize = Math.min(this.size, BooleanQuery.getMaxClauseCount());
            final PriorityQueue stQueue = new PriorityQueue();
            this.collectTerms(reader, query, new BooleanQueryRewrite.TermCollector(){
                private ScoreTerm st = new ScoreTerm();

                public boolean collect(Term t, float boost) {
                    if (stQueue.size() >= maxSize && boost <= ((ScoreTerm)stQueue.peek()).boost) {
                        return true;
                    }
                    this.st.term = t;
                    this.st.boost = boost;
                    stQueue.offer(this.st);
                    this.st = stQueue.size() > maxSize ? (ScoreTerm)stQueue.poll() : new ScoreTerm();
                    return true;
                }
            });
            BooleanQuery bq = new BooleanQuery(true);
            for (ScoreTerm st : stQueue) {
                TermQuery tq = new TermQuery(st.term);
                tq.setBoost(query.getBoost() * st.boost);
                bq.add(tq, BooleanClause.Occur.SHOULD);
            }
            query.incTotalNumberOfTerms(bq.clauses().size());
            return bq;
        }

        public int hashCode() {
            int prime = 17;
            int result = 1;
            result = 17 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TopTermsScoringBooleanQueryRewrite other = (TopTermsScoringBooleanQueryRewrite)obj;
            return this.size == other.size;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ScoreTerm
        implements Comparable<ScoreTerm> {
            public Term term;
            public float boost;

            private ScoreTerm() {
            }

            @Override
            public int compareTo(ScoreTerm other) {
                if (this.boost == other.boost) {
                    return other.term.compareTo(this.term);
                }
                return Float.compare(this.boost, other.boost);
            }
        }
    }

    private static class ScoringBooleanQueryRewrite
    extends BooleanQueryRewrite {
        private ScoringBooleanQueryRewrite() {
        }

        public Query rewrite(IndexReader reader, final MultiTermQuery query) throws IOException {
            final BooleanQuery result = new BooleanQuery(true);
            query.incTotalNumberOfTerms(this.collectTerms(reader, query, new BooleanQueryRewrite.TermCollector(){

                public boolean collect(Term t, float boost) {
                    TermQuery tq = new TermQuery(t);
                    tq.setBoost(query.getBoost() * boost);
                    result.add(tq, BooleanClause.Occur.SHOULD);
                    return true;
                }
            }));
            return result;
        }

        protected Object readResolve() {
            return SCORING_BOOLEAN_QUERY_REWRITE;
        }
    }

    private static abstract class BooleanQueryRewrite
    extends RewriteMethod {
        private BooleanQueryRewrite() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final int collectTerms(IndexReader reader, MultiTermQuery query, TermCollector collector) throws IOException {
            FilteredTermEnum enumerator = query.getEnum(reader);
            int count = 0;
            try {
                do {
                    Term t;
                    if ((t = enumerator.term()) == null) continue;
                    if (!collector.collect(t, enumerator.difference())) break;
                    ++count;
                } while (enumerator.next());
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                enumerator.close();
                throw throwable;
            }
            enumerator.close();
            return count;
        }

        protected static interface TermCollector {
            public boolean collect(Term var1, float var2) throws IOException;
        }
    }

    private static final class ConstantScoreFilterRewrite
    extends RewriteMethod {
        private ConstantScoreFilterRewrite() {
        }

        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            ConstantScoreQuery result = new ConstantScoreQuery(new MultiTermQueryWrapperFilter<MultiTermQuery>(query));
            result.setBoost(query.getBoost());
            return result;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_FILTER_REWRITE;
        }
    }

    public static abstract class RewriteMethod
    implements Serializable {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;
    }
}

