/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.ThreadInterruptedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelMultiSearcher
extends MultiSearcher {
    private final ExecutorService executor;
    private final Searchable[] searchables;
    private final int[] starts;

    public ParallelMultiSearcher(Searchable ... searchables) throws IOException {
        super(searchables);
        this.searchables = searchables;
        this.starts = this.getStarts();
        this.executor = Executors.newCachedThreadPool(new NamedThreadFactory(this.getClass().getSimpleName()));
    }

    @Override
    public int docFreq(final Term term) throws IOException {
        Future[] searchThreads = new Future[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            final Searchable searchable = this.searchables[i];
            searchThreads[i] = this.executor.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws IOException {
                    return searchable.docFreq(term);
                }
            });
        }
        CountDocFreq func = new CountDocFreq();
        this.foreach(func, Arrays.asList(searchThreads));
        return func.docFreq;
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        HitQueue hq = new HitQueue(nDocs, false);
        ReentrantLock lock = new ReentrantLock();
        Future[] searchThreads = new Future[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            searchThreads[i] = this.executor.submit(new MultiSearcher.MultiSearcherCallableNoSort(lock, this.searchables[i], weight, filter, nDocs, hq, i, this.starts));
        }
        CountTotalHits func = new CountTotalHits();
        this.foreach(func, Arrays.asList(searchThreads));
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        return new TopDocs(func.totalHits, scoreDocs, func.maxScore);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        if (sort == null) {
            throw new NullPointerException();
        }
        FieldDocSortedHitQueue hq = new FieldDocSortedHitQueue(nDocs);
        ReentrantLock lock = new ReentrantLock();
        Future[] searchThreads = new Future[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            searchThreads[i] = this.executor.submit(new MultiSearcher.MultiSearcherCallableWithSort(lock, this.searchables[i], weight, filter, nDocs, hq, sort, i, this.starts));
        }
        CountTotalHits func = new CountTotalHits();
        this.foreach(func, Arrays.asList(searchThreads));
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        return new TopFieldDocs(func.totalHits, scoreDocs, hq.getFields(), func.maxScore);
    }

    @Override
    public void search(Weight weight, Filter filter, final Collector collector) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int start = this.starts[i];
            Collector hc = new Collector(){

                public void setScorer(Scorer scorer) throws IOException {
                    collector.setScorer(scorer);
                }

                public void collect(int doc) throws IOException {
                    collector.collect(doc);
                }

                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                    collector.setNextReader(reader, start + docBase);
                }

                public boolean acceptsDocsOutOfOrder() {
                    return collector.acceptsDocsOutOfOrder();
                }
            };
            this.searchables[i].search(weight, filter, hc);
        }
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        super.close();
    }

    HashMap<Term, Integer> createDocFrequencyMap(Set<Term> terms) throws IOException {
        Term[] allTermsArray = terms.toArray(new Term[terms.size()]);
        int[] aggregatedDocFreqs = new int[terms.size()];
        ArrayList searchThreads = new ArrayList(this.searchables.length);
        for (Searchable searchable : this.searchables) {
            Future<int[]> future = this.executor.submit(new DocumentFrequencyCallable(searchable, allTermsArray));
            searchThreads.add(future);
        }
        this.foreach(new AggregateDocFrequency(aggregatedDocFreqs), searchThreads);
        HashMap<Term, Integer> dfMap = new HashMap<Term, Integer>();
        for (int i = 0; i < allTermsArray.length; ++i) {
            dfMap.put(allTermsArray[i], aggregatedDocFreqs[i]);
        }
        return dfMap;
    }

    private <T> void foreach(Function<T> func, List<Future<T>> list) throws IOException {
        for (Future<T> future : list) {
            try {
                func.apply(future.get());
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new RuntimeException(throwable);
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DocumentFrequencyCallable
    implements Callable<int[]> {
        private final Searchable searchable;
        private final Term[] terms;

        public DocumentFrequencyCallable(Searchable searchable, Term[] terms) {
            this.searchable = searchable;
            this.terms = terms;
        }

        @Override
        public int[] call() throws Exception {
            return this.searchable.docFreqs(this.terms);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AggregateDocFrequency
    implements Function<int[]> {
        final int[] aggregatedDocFreqs;

        public AggregateDocFrequency(int[] aggregatedDocFreqs) {
            this.aggregatedDocFreqs = aggregatedDocFreqs;
        }

        @Override
        public void apply(int[] docFreqs) {
            for (int i = 0; i < this.aggregatedDocFreqs.length; ++i) {
                int n = i;
                this.aggregatedDocFreqs[n] = this.aggregatedDocFreqs[n] + docFreqs[i];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CountDocFreq
    implements Function<Integer> {
        int docFreq = 0;

        private CountDocFreq() {
        }

        @Override
        public void apply(Integer t) {
            this.docFreq += t.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CountTotalHits<T extends TopDocs>
    implements Function<T> {
        int totalHits = 0;
        float maxScore = Float.NEGATIVE_INFINITY;

        private CountTotalHits() {
        }

        @Override
        public void apply(T t) {
            this.totalHits += ((TopDocs)t).totalHits;
            this.maxScore = Math.max(this.maxScore, ((TopDocs)t).getMaxScore());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Function<T> {
        public void apply(T var1);
    }
}

