/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Similarity;

public abstract class Scorer
extends DocIdSetIterator {
    private final Similarity similarity;

    protected Scorer(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void score(Collector collector) throws IOException {
        int doc;
        collector.setScorer(this);
        while ((doc = this.nextDoc()) != Integer.MAX_VALUE) {
            collector.collect(doc);
        }
    }

    protected boolean score(Collector collector, int max, int firstDocID) throws IOException {
        collector.setScorer(this);
        int doc = firstDocID;
        while (doc < max) {
            collector.collect(doc);
            doc = this.nextDoc();
        }
        return doc != Integer.MAX_VALUE;
    }

    public abstract float score() throws IOException;
}

