/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.store.RAMDirectory;

class RAMFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<byte[]> buffers = new ArrayList();
    long length;
    RAMDirectory directory;
    long sizeInBytes;
    private long lastModified = System.currentTimeMillis();

    RAMFile() {
    }

    RAMFile(RAMDirectory directory) {
        this.directory = directory;
    }

    synchronized long getLength() {
        return this.length;
    }

    synchronized void setLength(long length) {
        this.length = length;
    }

    synchronized long getLastModified() {
        return this.lastModified;
    }

    synchronized void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] addBuffer(int size) {
        byte[] buffer = this.newBuffer(size);
        RAMFile rAMFile = this;
        synchronized (rAMFile) {
            this.buffers.add(buffer);
            this.sizeInBytes += (long)size;
        }
        if (this.directory != null) {
            this.directory.sizeInBytes.getAndAdd(size);
        }
        return buffer;
    }

    final synchronized byte[] getBuffer(int index) {
        return this.buffers.get(index);
    }

    final synchronized int numBuffers() {
        return this.buffers.size();
    }

    byte[] newBuffer(int size) {
        return new byte[size];
    }

    synchronized long getSizeInBytes() {
        return this.sizeInBytes;
    }
}

