/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.cache.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SimpleMapCache<K, V>
extends Cache<K, V> {
    protected Map<K, V> map;

    public SimpleMapCache() {
        this(new HashMap());
    }

    public SimpleMapCache(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    Cache<K, V> getSynchronizedCache() {
        return new SynchronizedSimpleMapCache(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedSimpleMapCache<K, V>
    extends SimpleMapCache<K, V> {
        private Object mutex;
        private SimpleMapCache<K, V> cache;

        SynchronizedSimpleMapCache(SimpleMapCache<K, V> cache) {
            this.cache = cache;
            this.mutex = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.keySet();
            }
        }

        @Override
        Cache<K, V> getSynchronizedCache() {
            return this;
        }
    }
}

