/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.packed.PackedInts;

public abstract class DocValues
implements Closeable {
    public static final DocValues[] EMPTY_ARRAY = new DocValues[0];
    private volatile SourceCache cache = new SourceCache.DirectSourceCache();
    private final Object cacheLock = new Object();

    protected DocValues() {
    }

    protected abstract Source loadSource() throws IOException;

    public Source getSource() throws IOException {
        return this.cache.load(this);
    }

    public Source getDirectSource() throws IOException {
        return this.cache.loadDirect(this);
    }

    protected abstract Source loadDirectSource() throws IOException;

    public abstract Type getType();

    @Override
    public void close() throws IOException {
        this.cache.close(this);
    }

    public int getValueSize() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(SourceCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache must not be null");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            SourceCache toClose = this.cache;
            this.cache = cache;
            toClose.close(this);
        }
    }

    SourceCache getCache() {
        return this.cache;
    }

    public static Source getDefaultSource(Type type) {
        return new Source(type){

            @Override
            public long getInt(int docID) {
                return 0L;
            }

            @Override
            public double getFloat(int docID) {
                return 0.0;
            }

            @Override
            public BytesRef getBytes(int docID, BytesRef ref) {
                ref.length = 0;
                return ref;
            }
        };
    }

    public static SortedSource getDefaultSortedSource(Type type, final int size) {
        final PackedInts.Reader docToOrd = new PackedInts.Reader(){

            @Override
            public long get(int index) {
                return 0L;
            }

            @Override
            public int getBitsPerValue() {
                return 0;
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean hasArray() {
                return false;
            }

            @Override
            public Object getArray() {
                return null;
            }

            @Override
            public int get(int index, long[] arr, int off, int len) {
                len = Math.min(len, this.size() - index);
                Arrays.fill(arr, off, off + len, 0L);
                return len;
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        };
        return new SortedSource(type, BytesRef.getUTF8SortedAsUnicodeComparator()){

            @Override
            public BytesRef getBytes(int docID, BytesRef ref) {
                ref.length = 0;
                return ref;
            }

            @Override
            public int ord(int docID) {
                return 0;
            }

            @Override
            public BytesRef getByOrd(int ord, BytesRef bytesRef) {
                assert (ord == 0);
                bytesRef.length = 0;
                return bytesRef;
            }

            @Override
            public boolean hasPackedDocToOrd() {
                return true;
            }

            @Override
            public PackedInts.Reader getDocToOrd() {
                return docToOrd;
            }

            @Override
            public int getOrdByValue(BytesRef value, BytesRef spare) {
                if (value.length == 0) {
                    return 0;
                }
                return -1;
            }

            @Override
            public int getValueCount() {
                return 1;
            }
        };
    }

    public static abstract class SourceCache {
        protected SourceCache() {
        }

        public abstract Source load(DocValues var1) throws IOException;

        public abstract Source loadDirect(DocValues var1) throws IOException;

        public abstract void invalidate(DocValues var1);

        public synchronized void close(DocValues values) {
            this.invalidate(values);
        }

        public static final class DirectSourceCache
        extends SourceCache {
            private Source ref;
            private final CloseableThreadLocal<Source> directSourceCache = new CloseableThreadLocal();

            @Override
            public synchronized Source load(DocValues values) throws IOException {
                if (this.ref == null) {
                    this.ref = values.loadSource();
                }
                return this.ref;
            }

            @Override
            public synchronized void invalidate(DocValues values) {
                this.ref = null;
                this.directSourceCache.close();
            }

            @Override
            public synchronized Source loadDirect(DocValues values) throws IOException {
                Source source = this.directSourceCache.get();
                if (source == null) {
                    Source loadDirectSource = values.loadDirectSource();
                    this.directSourceCache.set(loadDirectSource);
                    return loadDirectSource;
                }
                return source;
            }
        }
    }

    public static enum Type {
        VAR_INTS,
        FIXED_INTS_8,
        FIXED_INTS_16,
        FIXED_INTS_32,
        FIXED_INTS_64,
        FLOAT_32,
        FLOAT_64,
        BYTES_FIXED_STRAIGHT,
        BYTES_FIXED_DEREF,
        BYTES_VAR_STRAIGHT,
        BYTES_VAR_DEREF,
        BYTES_VAR_SORTED,
        BYTES_FIXED_SORTED;

    }

    public static abstract class SortedSource
    extends Source {
        private final Comparator<BytesRef> comparator;

        protected SortedSource(Type type, Comparator<BytesRef> comparator) {
            super(type);
            this.comparator = comparator;
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef bytesRef) {
            int ord = this.ord(docID);
            if (ord < 0) {
                bytesRef.length = 0;
            } else {
                this.getByOrd(ord, bytesRef);
            }
            return bytesRef;
        }

        public abstract int ord(int var1);

        public abstract BytesRef getByOrd(int var1, BytesRef var2);

        public boolean hasPackedDocToOrd() {
            return false;
        }

        public abstract PackedInts.Reader getDocToOrd();

        public Comparator<BytesRef> getComparator() {
            return this.comparator;
        }

        public int getOrdByValue(BytesRef value, BytesRef spare) {
            return this.binarySearch(value, spare, 0, this.getValueCount() - 1);
        }

        private int binarySearch(BytesRef b, BytesRef bytesRef, int low, int high) {
            int mid = 0;
            while (low <= high) {
                mid = low + high >>> 1;
                this.getByOrd(mid, bytesRef);
                int cmp = this.comparator.compare(bytesRef, b);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            assert (this.comparator.compare(bytesRef, b) != 0);
            return -(low + 1);
        }

        @Override
        public SortedSource asSortedSource() {
            return this;
        }

        public abstract int getValueCount();
    }

    public static abstract class Source {
        protected final Type type;

        protected Source(Type type) {
            this.type = type;
        }

        public long getInt(int docID) {
            throw new UnsupportedOperationException("ints are not supported");
        }

        public double getFloat(int docID) {
            throw new UnsupportedOperationException("floats are not supported");
        }

        public BytesRef getBytes(int docID, BytesRef ref) {
            throw new UnsupportedOperationException("bytes are not supported");
        }

        public Type getType() {
            return this.type;
        }

        public boolean hasArray() {
            return false;
        }

        public Object getArray() {
            throw new UnsupportedOperationException("getArray is not supported");
        }

        public SortedSource asSortedSource() {
            throw new UnsupportedOperationException("asSortedSource is not supported");
        }
    }
}

