/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene42;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class Lucene42DocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, FSTEntry> fsts;
    private final IndexInput data;
    private final Map<Integer, NumericDocValues> numericInstances;
    private final Map<Integer, BinaryDocValues> binaryInstances;
    private final Map<Integer, FST<Long>> fstInstances;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Lucene42DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block5: {
            IndexInput in;
            block4: {
                this.numericInstances = new HashMap<Integer, NumericDocValues>();
                this.binaryInstances = new HashMap<Integer, BinaryDocValues>();
                this.fstInstances = new HashMap<Integer, FST<Long>>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openInput(metaName, state.context);
                boolean success = false;
                try {
                    CodecUtil.checkHeader(in, metaCodec, 0, 0);
                    this.numerics = new HashMap<Integer, NumericEntry>();
                    this.binaries = new HashMap<Integer, BinaryEntry>();
                    this.fsts = new HashMap<Integer, FSTEntry>();
                    this.readFields(in, state.fieldInfos);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in);
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block5;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        CodecUtil.checkHeader(this.data, dataCodec, 0, 0);
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                entry = new NumericEntry();
                ((NumericEntry)entry).offset = meta.readLong();
                ((NumericEntry)entry).format = meta.readByte();
                if (((NumericEntry)entry).format != 2) {
                    ((NumericEntry)entry).packedIntsVersion = meta.readVInt();
                }
                this.numerics.put(fieldNumber, (NumericEntry)entry);
            } else if (fieldType == 1) {
                entry = new BinaryEntry();
                ((BinaryEntry)entry).offset = meta.readLong();
                ((BinaryEntry)entry).numBytes = meta.readLong();
                ((BinaryEntry)entry).minLength = meta.readVInt();
                ((BinaryEntry)entry).maxLength = meta.readVInt();
                if (((BinaryEntry)entry).minLength != ((BinaryEntry)entry).maxLength) {
                    ((BinaryEntry)entry).packedIntsVersion = meta.readVInt();
                    ((BinaryEntry)entry).blockSize = meta.readVInt();
                }
                this.binaries.put(fieldNumber, (BinaryEntry)entry);
            } else if (fieldType == 2) {
                entry = new FSTEntry();
                ((FSTEntry)entry).offset = meta.readLong();
                ((FSTEntry)entry).numOrds = meta.readVLong();
                this.fsts.put(fieldNumber, (FSTEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.number);
        if (instance == null) {
            instance = this.loadNumeric(field);
            this.numericInstances.put(field.number, instance);
        }
        return instance;
    }

    private NumericDocValues loadNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        this.data.seek(entry.offset);
        if (entry.format == 1) {
            int size = this.data.readVInt();
            final long[] decode = new long[size];
            for (int i = 0; i < decode.length; ++i) {
                decode[i] = this.data.readLong();
            }
            int formatID = this.data.readVInt();
            int bitsPerValue = this.data.readVInt();
            final PackedInts.Reader reader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), entry.packedIntsVersion, this.maxDoc, bitsPerValue);
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    return decode[(int)reader.get(docID)];
                }
            };
        }
        if (entry.format == 0) {
            int blockSize = this.data.readVInt();
            final BlockPackedReader reader = new BlockPackedReader(this.data, entry.packedIntsVersion, blockSize, this.maxDoc, false);
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    return reader.get(docID);
                }
            };
        }
        if (entry.format == 2) {
            final byte[] bytes = new byte[this.maxDoc];
            this.data.readBytes(bytes, 0, bytes.length);
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    return bytes[docID];
                }
            };
        }
        throw new IllegalStateException();
    }

    @Override
    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field.number);
        if (instance == null) {
            instance = this.loadBinary(field);
            this.binaryInstances.put(field.number, instance);
        }
        return instance;
    }

    private BinaryDocValues loadBinary(FieldInfo field) throws IOException {
        BinaryEntry entry = this.binaries.get(field.number);
        this.data.seek(entry.offset);
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(this.data, entry.numBytes);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        if (entry.minLength == entry.maxLength) {
            final int fixedLength = entry.minLength;
            return new BinaryDocValues(){

                @Override
                public void get(int docID, BytesRef result) {
                    bytesReader.fillSlice(result, (long)fixedLength * (long)docID, fixedLength);
                }
            };
        }
        final MonotonicBlockPackedReader addresses = new MonotonicBlockPackedReader(this.data, entry.packedIntsVersion, entry.blockSize, this.maxDoc, false);
        return new BinaryDocValues(){

            @Override
            public void get(int docID, BytesRef result) {
                long startAddress = docID == 0 ? 0L : addresses.get(docID - 1);
                long endAddress = addresses.get(docID);
                bytesReader.fillSlice(result, startAddress, (int)(endAddress - startAddress));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        FST<Long> instance;
        final FSTEntry entry = this.fsts.get(field.number);
        Lucene42DocValuesProducer lucene42DocValuesProducer = this;
        synchronized (lucene42DocValuesProducer) {
            instance = this.fstInstances.get(field.number);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton(true));
                this.fstInstances.put(field.number, instance);
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            @Override
            public void lookupOrd(int ord, BytesRef result) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    result.bytes = new byte[output.length];
                    result.offset = 0;
                    result.length = 0;
                    Util.toBytesRef(output, result);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int getValueCount() {
                return (int)entry.numOrds;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        FST<Long> instance;
        final FSTEntry entry = this.fsts.get(field.number);
        if (entry.numOrds == 0L) {
            return SortedSetDocValues.EMPTY;
        }
        Lucene42DocValuesProducer lucene42DocValuesProducer = this;
        synchronized (lucene42DocValuesProducer) {
            instance = this.fstInstances.get(field.number);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton(true));
                this.fstInstances.put(field.number, instance);
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        final BytesRef ref = new BytesRef();
        final ByteArrayDataInput input = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            long currentOrd;

            @Override
            public long nextOrd() {
                if (input.eof()) {
                    return -1L;
                }
                this.currentOrd += input.readVLong();
                return this.currentOrd;
            }

            @Override
            public void setDocument(int docID) {
                docToOrds.get(docID, ref);
                input.reset(ref.bytes, ref.offset, ref.length);
                this.currentOrd = 0L;
            }

            @Override
            public void lookupOrd(long ord, BytesRef result) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    result.bytes = new byte[output.length];
                    result.offset = 0;
                    result.length = 0;
                    Util.toBytesRef(output, result);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long getValueCount() {
                return entry.numOrds;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

