/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.comparators.NumericComparator;

public class DoubleComparator
extends NumericComparator<Double> {
    private final double[] values;
    protected double topValue;
    protected double bottom;

    public DoubleComparator(int numHits, String field, Double missingValue, boolean reverse, int sortPos) {
        super(field, missingValue != null ? missingValue : 0.0, reverse, sortPos, 8);
        this.values = new double[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setTopValue(Double value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    public Double value(int slot) {
        return this.values[slot];
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new DoubleLeafComparator(context);
    }

    public class DoubleLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public DoubleLeafComparator(LeafReaderContext context) throws IOException {
            super(DoubleComparator.this, context);
        }

        private double getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return Double.longBitsToDouble(this.docValues.longValue());
            }
            return (Double)DoubleComparator.this.missingValue;
        }

        @Override
        public void setBottom(int slot) throws IOException {
            DoubleComparator.this.bottom = DoubleComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Double.compare(DoubleComparator.this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Double.compare(DoubleComparator.this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            DoubleComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected boolean isMissingValueCompetitive() {
            int result = Double.compare((Double)DoubleComparator.this.missingValue, DoubleComparator.this.bottom);
            return DoubleComparator.this.reverse ? result >= 0 : result <= 0;
        }

        @Override
        protected void encodeBottom(byte[] packedValue) {
            DoublePoint.encodeDimension(DoubleComparator.this.bottom, packedValue, 0);
        }

        @Override
        protected void encodeTop(byte[] packedValue) {
            DoublePoint.encodeDimension(DoubleComparator.this.topValue, packedValue, 0);
        }
    }
}

