/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.mahout.fpm.pfpgrowth.convertors;

import java.io.IOException;

import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapreduce.Reducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * An output collector for {@link Reducer} for PFPGrowth which updates the status as well as writes the
 * patterns generated by the algorithm
 * 
 * @param <IK>
 * @param <IV>
 * @param <K>
 * @param <V>
 */
public class ContextWriteOutputCollector<IK extends Writable,IV extends Writable,K extends Writable,V extends Writable>
    implements OutputCollector<K,V> {
  
  private static final Logger log = LoggerFactory.getLogger(ContextWriteOutputCollector.class);
  
  private final Reducer<IK,IV,K,V>.Context context;
  
  public ContextWriteOutputCollector(Reducer<IK,IV,K,V>.Context context) {
    this.context = context;
  }
  
  @Override
  public final void collect(K key, V value) throws IOException {
    try {
      context.setStatus("Writing Top K patterns for: " + key);
      context.write(key, value);
    } catch (InterruptedException e) {
      log.error("{}", e.toString());
    }
  }
  
}
