/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.MutableRecommendedItem;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.TopItemsQueue;
import org.apache.mahout.cf.taste.hadoop.item.IDReader;
import org.apache.mahout.cf.taste.hadoop.item.PrefAndSimilarityColumnWritable;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregateAndRecommendReducer
extends Reducer<VarLongWritable, PrefAndSimilarityColumnWritable, VarLongWritable, RecommendedItemsWritable> {
    private static final Logger log = LoggerFactory.getLogger(AggregateAndRecommendReducer.class);
    static final String ITEMID_INDEX_PATH = "itemIDIndexPath";
    static final String NUM_RECOMMENDATIONS = "numRecommendations";
    static final int DEFAULT_NUM_RECOMMENDATIONS = 10;
    static final String ITEMS_FILE = "itemsFile";
    private boolean booleanData;
    private int recommendationsPerUser;
    private IDReader idReader;
    private FastIDSet itemsToRecommendFor;
    private OpenIntLongHashMap indexItemIDMap;
    private final RecommendedItemsWritable recommendedItems = new RecommendedItemsWritable();
    private static final float BOOLEAN_PREF_VALUE = 1.0f;

    protected void setup(Reducer.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        this.recommendationsPerUser = conf.getInt(NUM_RECOMMENDATIONS, 10);
        this.booleanData = conf.getBoolean("booleanData", false);
        this.indexItemIDMap = TasteHadoopUtils.readIDIndexMap(conf.get(ITEMID_INDEX_PATH), conf);
        this.idReader = new IDReader(conf);
        this.idReader.readIDs();
        this.itemsToRecommendFor = this.idReader.getItemIds();
    }

    protected void reduce(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (this.booleanData) {
            this.reduceBooleanData(userID, values, context);
        } else {
            this.reduceNonBooleanData(userID, values, context);
        }
    }

    private void reduceBooleanData(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<PrefAndSimilarityColumnWritable> columns = values.iterator();
        Vector predictions = columns.next().getSimilarityColumn();
        while (columns.hasNext()) {
            predictions.assign(columns.next().getSimilarityColumn(), Functions.PLUS);
        }
        this.writeRecommendedItems(userID, predictions, context);
    }

    private void reduceNonBooleanData(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Vector numerators = null;
        Vector denominators = null;
        RandomAccessSparseVector numberOfSimilarItemsUsed = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        for (PrefAndSimilarityColumnWritable prefAndSimilarityColumn : values) {
            Vector simColumn = prefAndSimilarityColumn.getSimilarityColumn();
            float prefValue = prefAndSimilarityColumn.getPrefValue();
            for (Vector.Element e : simColumn.nonZeroes()) {
                int itemIDIndex = e.index();
                numberOfSimilarItemsUsed.setQuick(itemIDIndex, numberOfSimilarItemsUsed.getQuick(itemIDIndex) + 1.0);
            }
            if (denominators == null) {
                denominators = simColumn.clone();
            } else {
                denominators.assign(simColumn, Functions.PLUS_ABS);
            }
            if (numerators == null) {
                numerators = simColumn.clone();
                if (prefValue == 1.0f) continue;
                numerators.assign(Functions.MULT, (double)prefValue);
                continue;
            }
            if (prefValue != 1.0f) {
                simColumn.assign(Functions.MULT, (double)prefValue);
            }
            numerators.assign(simColumn, Functions.PLUS);
        }
        if (numerators == null) {
            return;
        }
        RandomAccessSparseVector recommendationVector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        for (Vector.Element element : numerators.nonZeroes()) {
            int itemIDIndex = element.index();
            if (!(numberOfSimilarItemsUsed.getQuick(itemIDIndex) > 1.0)) continue;
            double prediction = element.get() / denominators.getQuick(itemIDIndex);
            recommendationVector.setQuick(itemIDIndex, prediction);
        }
        this.writeRecommendedItems(userID, (Vector)recommendationVector, context);
    }

    private void writeRecommendedItems(VarLongWritable userID, Vector recommendationVector, Reducer.Context context) throws IOException, InterruptedException {
        TopItemsQueue topKItems = new TopItemsQueue(this.recommendationsPerUser);
        FastIDSet itemsForUser = null;
        if (this.idReader != null && this.idReader.isUserItemFilterSpecified()) {
            itemsForUser = this.idReader.getItemsToRecommendForUser(userID.get());
        }
        for (Vector.Element element : recommendationVector.nonZeroes()) {
            MutableRecommendedItem topItem;
            float value;
            int index = element.index();
            long itemID = this.indexItemIDMap != null && !this.indexItemIDMap.isEmpty() ? this.indexItemIDMap.get(index) : (long)index;
            if (!this.shouldIncludeItemIntoRecommendations(itemID, this.itemsToRecommendFor, itemsForUser) || Float.isNaN(value = (float)element.get()) || !(value > (topItem = (MutableRecommendedItem)topKItems.top()).getValue())) continue;
            topItem.set(itemID, value);
            topKItems.updateTop();
        }
        List<RecommendedItem> topItems = topKItems.getTopItems();
        if (!topItems.isEmpty()) {
            this.recommendedItems.set(topItems);
            context.write((Object)userID, (Object)this.recommendedItems);
        }
    }

    private boolean shouldIncludeItemIntoRecommendations(long itemID, FastIDSet allItemsToRecommendFor, FastIDSet itemsForUser) {
        if (allItemsToRecommendFor == null && itemsForUser == null) {
            return true;
        }
        if (itemsForUser != null) {
            return itemsForUser.contains(itemID);
        }
        if (allItemsToRecommendFor != null) {
            return allItemsToRecommendFor.contains(itemID);
        }
        return false;
    }
}

