/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.CountingIterator;

public final class GenericItemPreferenceArray
implements PreferenceArray {
    private static final int USER = 0;
    private static final int VALUE = 2;
    private static final int VALUE_REVERSED = 3;
    private final long[] ids;
    private long id;
    private final float[] values;

    public GenericItemPreferenceArray(int size) {
        this.ids = new long[size];
        this.values = new float[size];
        this.id = Long.MIN_VALUE;
    }

    public GenericItemPreferenceArray(List<? extends Preference> prefs) {
        this(prefs.size());
        int size = prefs.size();
        long itemID = Long.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            Preference pref = prefs.get(i);
            this.ids[i] = pref.getUserID();
            if (i == 0) {
                itemID = pref.getItemID();
            } else if (itemID != pref.getItemID()) {
                throw new IllegalArgumentException("Not all item IDs are the same");
            }
            this.values[i] = pref.getValue();
        }
        this.id = itemID;
    }

    private GenericItemPreferenceArray(long[] ids, long id, float[] values) {
        this.ids = ids;
        this.id = id;
        this.values = values;
    }

    @Override
    public int length() {
        return this.ids.length;
    }

    @Override
    public Preference get(int i) {
        return new PreferenceView(i);
    }

    @Override
    public void set(int i, Preference pref) {
        this.id = pref.getItemID();
        this.ids[i] = pref.getUserID();
        this.values[i] = pref.getValue();
    }

    @Override
    public long getUserID(int i) {
        return this.ids[i];
    }

    @Override
    public void setUserID(int i, long userID) {
        this.ids[i] = userID;
    }

    @Override
    public long getItemID(int i) {
        return this.id;
    }

    @Override
    public void setItemID(int i, long itemID) {
        this.id = itemID;
    }

    @Override
    public long[] getIDs() {
        return this.ids;
    }

    @Override
    public float getValue(int i) {
        return this.values[i];
    }

    @Override
    public void setValue(int i, float value) {
        this.values[i] = value;
    }

    @Override
    public void sortByUser() {
        this.lateralSort(0);
    }

    @Override
    public void sortByItem() {
    }

    @Override
    public void sortByValue() {
        this.lateralSort(2);
    }

    @Override
    public void sortByValueReversed() {
        this.lateralSort(3);
    }

    @Override
    public boolean hasPrefWithUserID(long userID) {
        for (long id : this.ids) {
            if (userID != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPrefWithItemID(long itemID) {
        return this.id == itemID;
    }

    private void lateralSort(int type) {
        int length;
        int gap = length = this.length();
        boolean swapped = false;
        while (gap > 1 || swapped) {
            if (gap > 1) {
                gap = (int)((double)gap / 1.247330950103979);
            }
            swapped = false;
            int max = length - gap;
            for (int i = 0; i < max; ++i) {
                int other = i + gap;
                if (!this.isLess(other, i, type)) continue;
                this.swap(i, other);
                swapped = true;
            }
        }
    }

    private boolean isLess(int i, int j, int type) {
        switch (type) {
            case 0: {
                return this.ids[i] < this.ids[j];
            }
            case 2: {
                return this.values[i] < this.values[j];
            }
            case 3: {
                return this.values[i] > this.values[j];
            }
        }
        throw new IllegalStateException();
    }

    private void swap(int i, int j) {
        long temp1 = this.ids[i];
        float temp2 = this.values[i];
        this.ids[i] = this.ids[j];
        this.values[i] = this.values[j];
        this.ids[j] = temp1;
        this.values[j] = temp2;
    }

    @Override
    public GenericItemPreferenceArray clone() {
        return new GenericItemPreferenceArray((long[])this.ids.clone(), this.id, (float[])this.values.clone());
    }

    public int hashCode() {
        return (int)(this.id >> 32) ^ (int)this.id ^ Arrays.hashCode(this.ids) ^ Arrays.hashCode(this.values);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenericItemPreferenceArray)) {
            return false;
        }
        GenericItemPreferenceArray otherArray = (GenericItemPreferenceArray)other;
        return this.id == otherArray.id && Arrays.equals(this.ids, otherArray.ids) && Arrays.equals(this.values, otherArray.values);
    }

    @Override
    public Iterator<Preference> iterator() {
        return Iterators.transform((Iterator)((Object)new CountingIterator(this.length())), (Function)new Function<Integer, Preference>(){

            public Preference apply(Integer from) {
                return new PreferenceView(from);
            }
        });
    }

    public String toString() {
        if (this.ids == null || this.ids.length == 0) {
            return "GenericItemPreferenceArray[{}]";
        }
        StringBuilder result = new StringBuilder(20 * this.ids.length);
        result.append("GenericItemPreferenceArray[itemID:");
        result.append(this.id);
        result.append(",{");
        for (int i = 0; i < this.ids.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.ids[i]);
            result.append('=');
            result.append(this.values[i]);
        }
        result.append("}]");
        return result.toString();
    }

    private final class PreferenceView
    implements Preference {
        private final int i;

        private PreferenceView(int i) {
            this.i = i;
        }

        @Override
        public long getUserID() {
            return GenericItemPreferenceArray.this.getUserID(this.i);
        }

        @Override
        public long getItemID() {
            return GenericItemPreferenceArray.this.getItemID(this.i);
        }

        @Override
        public float getValue() {
            return GenericItemPreferenceArray.this.values[this.i];
        }

        @Override
        public void setValue(float value) {
            ((GenericItemPreferenceArray)GenericItemPreferenceArray.this).values[this.i] = value;
        }
    }
}

