/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.MostSimilarItemsCandidateItemsStrategy;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

public final class GenericBooleanPrefItemBasedRecommender
extends GenericItemBasedRecommender {
    public GenericBooleanPrefItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity) {
        super(dataModel, similarity);
    }

    public GenericBooleanPrefItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity, CandidateItemsStrategy candidateItemsStrategy, MostSimilarItemsCandidateItemsStrategy mostSimilarItemsCandidateItemsStrategy) {
        super(dataModel, similarity, candidateItemsStrategy, mostSimilarItemsCandidateItemsStrategy);
    }

    @Override
    protected float doEstimatePreference(long userID, PreferenceArray preferencesFromUser, long itemID) throws TasteException {
        double[] similarities = this.getSimilarity().itemSimilarities(itemID, preferencesFromUser.getIDs());
        boolean foundAPref = false;
        double totalSimilarity = 0.0;
        for (double theSimilarity : similarities) {
            if (Double.isNaN(theSimilarity)) continue;
            foundAPref = true;
            totalSimilarity += theSimilarity;
        }
        return foundAPref ? (float)totalSimilarity : Float.NaN;
    }

    @Override
    public String toString() {
        return "GenericBooleanPrefItemBasedRecommender";
    }
}

