/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.RandomUtils;

public final class RandomRecommender
extends AbstractRecommender {
    private final Random random = RandomUtils.getRandom();
    private final float minPref;
    private final float maxPref;

    public RandomRecommender(DataModel dataModel) throws TasteException {
        super(dataModel);
        float maxPref = Float.NEGATIVE_INFINITY;
        float minPref = Float.POSITIVE_INFINITY;
        LongPrimitiveIterator userIterator = dataModel.getUserIDs();
        while (userIterator.hasNext()) {
            long userID = (Long)userIterator.next();
            PreferenceArray prefs = dataModel.getPreferencesFromUser(userID);
            for (int i = 0; i < prefs.length(); ++i) {
                float prefValue = prefs.getValue(i);
                if (prefValue < minPref) {
                    minPref = prefValue;
                }
                if (!(prefValue > maxPref)) continue;
                maxPref = prefValue;
            }
        }
        this.minPref = minPref;
        this.maxPref = maxPref;
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        DataModel dataModel = this.getDataModel();
        int numItems = dataModel.getNumItems();
        ArrayList result = Lists.newArrayListWithCapacity((int)howMany);
        while (result.size() < howMany) {
            LongPrimitiveIterator it = dataModel.getItemIDs();
            it.skip(this.random.nextInt(numItems));
            long itemID = (Long)it.next();
            if (dataModel.getPreferenceValue(userID, itemID) != null) continue;
            result.add(new GenericRecommendedItem(itemID, this.randomPref()));
        }
        return result;
    }

    @Override
    public float estimatePreference(long userID, long itemID) {
        return this.randomPref();
    }

    private float randomPref() {
        return this.minPref + this.random.nextFloat() * (this.maxPref - this.minPref);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.getDataModel().refresh(alreadyRefreshed);
    }
}

