/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.common.Weighting;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.similarity.AbstractItemSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

abstract class AbstractSimilarity
extends AbstractItemSimilarity
implements UserSimilarity {
    private PreferenceInferrer inferrer;
    private final boolean weighted;
    private final boolean centerData;
    private int cachedNumItems;
    private int cachedNumUsers;
    private final RefreshHelper refreshHelper;

    AbstractSimilarity(final DataModel dataModel, Weighting weighting, boolean centerData) throws TasteException {
        super(dataModel);
        this.weighted = weighting == Weighting.WEIGHTED;
        this.centerData = centerData;
        this.cachedNumItems = dataModel.getNumItems();
        this.cachedNumUsers = dataModel.getNumUsers();
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                AbstractSimilarity.this.cachedNumItems = dataModel.getNumItems();
                AbstractSimilarity.this.cachedNumUsers = dataModel.getNumUsers();
                return null;
            }
        });
    }

    final PreferenceInferrer getPreferenceInferrer() {
        return this.inferrer;
    }

    @Override
    public final void setPreferenceInferrer(PreferenceInferrer inferrer) {
        Preconditions.checkArgument((inferrer != null ? 1 : 0) != 0, (Object)"inferrer is null");
        this.refreshHelper.addDependency(inferrer);
        this.refreshHelper.removeDependency(this.inferrer);
        this.inferrer = inferrer;
    }

    final boolean isWeighted() {
        return this.weighted;
    }

    abstract double computeResult(int var1, double var2, double var4, double var6, double var8);

    @Override
    public double userSimilarity(long userID1, long userID2) throws TasteException {
        double result;
        boolean hasInferrer;
        DataModel dataModel = this.getDataModel();
        PreferenceArray xPrefs = dataModel.getPreferencesFromUser(userID1);
        PreferenceArray yPrefs = dataModel.getPreferencesFromUser(userID2);
        int xLength = xPrefs.length();
        int yLength = yPrefs.length();
        if (xLength == 0 || yLength == 0) {
            return Double.NaN;
        }
        long xIndex = xPrefs.getItemID(0);
        long yIndex = yPrefs.getItemID(0);
        int xPrefIndex = 0;
        int yPrefIndex = 0;
        double sumX = 0.0;
        double sumX2 = 0.0;
        double sumY = 0.0;
        double sumY2 = 0.0;
        double sumXY = 0.0;
        double sumXYdiff2 = 0.0;
        int count = 0;
        boolean bl = hasInferrer = this.inferrer != null;
        while (true) {
            int compare;
            int n = xIndex < yIndex ? -1 : (compare = xIndex > yIndex ? 1 : 0);
            if (hasInferrer || compare == 0) {
                double y;
                double x;
                if (xIndex == yIndex) {
                    x = xPrefs.getValue(xPrefIndex);
                    y = yPrefs.getValue(yPrefIndex);
                } else if (compare < 0) {
                    x = xPrefs.getValue(xPrefIndex);
                    y = this.inferrer.inferPreference(userID2, xIndex);
                } else {
                    x = this.inferrer.inferPreference(userID1, yIndex);
                    y = yPrefs.getValue(yPrefIndex);
                }
                sumXY += x * y;
                sumX += x;
                sumX2 += x * x;
                sumY += y;
                sumY2 += y * y;
                double diff = x - y;
                sumXYdiff2 += diff * diff;
                ++count;
            }
            if (compare <= 0) {
                if (++xPrefIndex >= xLength) {
                    if (!hasInferrer || yIndex == Long.MAX_VALUE) break;
                    xIndex = Long.MAX_VALUE;
                } else {
                    xIndex = xPrefs.getItemID(xPrefIndex);
                }
            }
            if (compare < 0) continue;
            if (++yPrefIndex >= yLength) {
                if (!hasInferrer || xIndex == Long.MAX_VALUE) break;
                yIndex = Long.MAX_VALUE;
                continue;
            }
            yIndex = yPrefs.getItemID(yPrefIndex);
        }
        if (this.centerData) {
            double meanX = sumX / (double)count;
            double meanY = sumY / (double)count;
            double centeredSumXY = sumXY - meanY * sumX;
            double centeredSumX2 = sumX2 - meanX * sumX;
            double centeredSumY2 = sumY2 - meanY * sumY;
            result = this.computeResult(count, centeredSumXY, centeredSumX2, centeredSumY2, sumXYdiff2);
        } else {
            result = this.computeResult(count, sumXY, sumX2, sumY2, sumXYdiff2);
        }
        if (!Double.isNaN(result)) {
            result = this.normalizeWeightResult(result, count, this.cachedNumItems);
        }
        return result;
    }

    @Override
    public final double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        double result;
        DataModel dataModel = this.getDataModel();
        PreferenceArray xPrefs = dataModel.getPreferencesForItem(itemID1);
        PreferenceArray yPrefs = dataModel.getPreferencesForItem(itemID2);
        int xLength = xPrefs.length();
        int yLength = yPrefs.length();
        if (xLength == 0 || yLength == 0) {
            return Double.NaN;
        }
        long xIndex = xPrefs.getUserID(0);
        long yIndex = yPrefs.getUserID(0);
        int xPrefIndex = 0;
        int yPrefIndex = 0;
        double sumX = 0.0;
        double sumX2 = 0.0;
        double sumY = 0.0;
        double sumY2 = 0.0;
        double sumXY = 0.0;
        double sumXYdiff2 = 0.0;
        int count = 0;
        while (true) {
            int compare;
            int n = xIndex < yIndex ? -1 : (compare = xIndex > yIndex ? 1 : 0);
            if (compare == 0) {
                double x = xPrefs.getValue(xPrefIndex);
                double y = yPrefs.getValue(yPrefIndex);
                sumXY += x * y;
                sumX += x;
                sumX2 += x * x;
                sumY += y;
                sumY2 += y * y;
                double diff = x - y;
                sumXYdiff2 += diff * diff;
                ++count;
            }
            if (compare <= 0) {
                if (++xPrefIndex == xLength) break;
                xIndex = xPrefs.getUserID(xPrefIndex);
            }
            if (compare < 0) continue;
            if (++yPrefIndex == yLength) break;
            yIndex = yPrefs.getUserID(yPrefIndex);
        }
        if (this.centerData) {
            double n = count;
            double meanX = sumX / n;
            double meanY = sumY / n;
            double centeredSumXY = sumXY - meanY * sumX;
            double centeredSumX2 = sumX2 - meanX * sumX;
            double centeredSumY2 = sumY2 - meanY * sumY;
            result = this.computeResult(count, centeredSumXY, centeredSumX2, centeredSumY2, sumXYdiff2);
        } else {
            result = this.computeResult(count, sumXY, sumX2, sumY2, sumXYdiff2);
        }
        if (!Double.isNaN(result)) {
            result = this.normalizeWeightResult(result, count, this.cachedNumUsers);
        }
        return result;
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        int length = itemID2s.length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.itemSimilarity(itemID1, itemID2s[i]);
        }
        return result;
    }

    final double normalizeWeightResult(double result, int count, int num) {
        double normalizedResult = result;
        if (this.weighted) {
            double scaleFactor = 1.0 - (double)count / (double)(num + 1);
            normalizedResult = normalizedResult < 0.0 ? -1.0 + scaleFactor * (1.0 + normalizedResult) : 1.0 - scaleFactor * (1.0 - normalizedResult);
        }
        if (normalizedResult < -1.0) {
            normalizedResult = -1.0;
        } else if (normalizedResult > 1.0) {
            normalizedResult = 1.0;
        }
        return normalizedResult;
    }

    @Override
    public final void refresh(Collection<Refreshable> alreadyRefreshed) {
        super.refresh(alreadyRefreshed);
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[dataModel:" + this.getDataModel() + ",inferrer:" + this.inferrer + ']';
    }
}

