/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.common.Weighting;
import org.apache.mahout.cf.taste.impl.similarity.AbstractSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;

public final class UncenteredCosineSimilarity
extends AbstractSimilarity {
    public UncenteredCosineSimilarity(DataModel dataModel) throws TasteException {
        this(dataModel, Weighting.UNWEIGHTED);
    }

    public UncenteredCosineSimilarity(DataModel dataModel, Weighting weighting) throws TasteException {
        super(dataModel, weighting, false);
        Preconditions.checkArgument((boolean)dataModel.hasPreferenceValues(), (Object)"DataModel doesn't have preference values");
    }

    @Override
    double computeResult(int n, double sumXY, double sumX2, double sumY2, double sumXYdiff2) {
        if (n == 0) {
            return Double.NaN;
        }
        double denominator = Math.sqrt(sumX2) * Math.sqrt(sumY2);
        if (denominator == 0.0) {
            return Double.NaN;
        }
        return sumXY / denominator;
    }
}

