/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.similarity.precompute;

import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItem;

public class SimilarItems {
    private final long itemID;
    private final long[] similarItemIDs;
    private final double[] similarities;

    public SimilarItems(long itemID, List<RecommendedItem> similarItems) {
        this.itemID = itemID;
        int numSimilarItems = similarItems.size();
        this.similarItemIDs = new long[numSimilarItems];
        this.similarities = new double[numSimilarItems];
        for (int n = 0; n < numSimilarItems; ++n) {
            this.similarItemIDs[n] = similarItems.get(n).getItemID();
            this.similarities[n] = similarItems.get(n).getValue();
        }
    }

    public long getItemID() {
        return this.itemID;
    }

    public int numSimilarItems() {
        return this.similarItemIDs.length;
    }

    public Iterable<SimilarItem> getSimilarItems() {
        return new Iterable<SimilarItem>(){

            @Override
            public Iterator<SimilarItem> iterator() {
                return new SimilarItemsIterator();
            }
        };
    }

    private class SimilarItemsIterator
    extends UnmodifiableIterator<SimilarItem> {
        private int index = 0;

        private SimilarItemsIterator() {
        }

        public boolean hasNext() {
            return this.index < SimilarItems.this.similarItemIDs.length - 1;
        }

        public SimilarItem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return new SimilarItem(SimilarItems.this.similarItemIDs[this.index], SimilarItems.this.similarities[this.index]);
        }
    }
}

