/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.DescriptorException;

public final class DescriptorUtils {
    private static final Splitter SPACE = Splitter.on((char)' ').omitEmptyStrings();

    private DescriptorUtils() {
    }

    public static Dataset.Attribute[] parseDescriptor(CharSequence descriptor) throws DescriptorException {
        ArrayList attributes = Lists.newArrayList();
        for (String token : SPACE.split(descriptor)) {
            if ("I".equals(token = token.toUpperCase(Locale.ENGLISH))) {
                attributes.add(Dataset.Attribute.IGNORED);
                continue;
            }
            if ("N".equals(token)) {
                attributes.add(Dataset.Attribute.NUMERICAL);
                continue;
            }
            if ("C".equals(token)) {
                attributes.add(Dataset.Attribute.CATEGORICAL);
                continue;
            }
            if ("L".equals(token)) {
                attributes.add(Dataset.Attribute.LABEL);
                continue;
            }
            throw new DescriptorException("Bad Token : " + token);
        }
        return attributes.toArray(new Dataset.Attribute[attributes.size()]);
    }

    public static String generateDescriptor(CharSequence description) throws DescriptorException {
        return DescriptorUtils.generateDescriptor(SPACE.split(description));
    }

    public static String generateDescriptor(Iterable<String> tokens) throws DescriptorException {
        StringBuilder descriptor = new StringBuilder();
        int multiplicator = 0;
        for (String token : tokens) {
            try {
                int number = Integer.parseInt(token);
                if (number <= 0) {
                    throw new DescriptorException("Multiplicator (" + number + ") must be > 0");
                }
                if (multiplicator > 0) {
                    throw new DescriptorException("A multiplicator cannot be followed by another multiplicator");
                }
                multiplicator = number;
            }
            catch (NumberFormatException e) {
                if (multiplicator == 0) {
                    multiplicator = 1;
                }
                for (int index = 0; index < multiplicator; ++index) {
                    descriptor.append(token).append(' ');
                }
                multiplicator = 0;
            }
        }
        return descriptor.toString().trim();
    }
}

