/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

final class LossyHmmSerializer {
    private LossyHmmSerializer() {
    }

    static void serialize(HmmModel model, DataOutput output) throws IOException {
        MatrixWritable matrix = new MatrixWritable(model.getEmissionMatrix());
        matrix.write(output);
        matrix.set(model.getTransitionMatrix());
        matrix.write(output);
        VectorWritable vector = new VectorWritable(model.getInitialProbabilities());
        vector.write(output);
    }

    static HmmModel deserialize(DataInput input) throws IOException {
        MatrixWritable matrix = new MatrixWritable();
        matrix.readFields(input);
        Matrix emissionMatrix = matrix.get();
        matrix.readFields(input);
        Matrix transitionMatrix = matrix.get();
        VectorWritable vector = new VectorWritable();
        vector.readFields(input);
        Vector initialProbabilities = vector.get();
        return new HmmModel(transitionMatrix, emissionMatrix, initialProbabilities);
    }
}

