/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;

public final class UncommonDistributions {
    private static final RandomWrapper RANDOM = RandomUtils.getRandom();

    private UncommonDistributions() {
    }

    public static double rGamma(double k, double lambda) {
        double x;
        boolean accept = false;
        if (k >= 1.0) {
            double x2;
            double b = k - Math.log(4.0);
            double c = k + Math.sqrt(2.0 * k - 1.0);
            double lam = Math.sqrt(2.0 * k - 1.0);
            double cheng = 1.0 + Math.log(4.5);
            do {
                double z;
                double u = RANDOM.nextDouble();
                double v = RANDOM.nextDouble();
                double y = 1.0 / lam * Math.log(v / (1.0 - v));
                double r = b + c * y - (x2 = k * Math.exp(y));
                if (!(r >= 4.5 * (z = u * v * v) - cheng) && !(r >= Math.log(z))) continue;
                accept = true;
            } while (!accept);
            return x2 / lambda;
        }
        double c = 1.0 / k;
        double d = (1.0 - k) * Math.pow(k, k / (1.0 - k));
        do {
            double e;
            double u = RANDOM.nextDouble();
            double v = RANDOM.nextDouble();
            double z = -Math.log(u);
            if (!(z + (e = -Math.log(v)) >= d + (x = Math.pow(z, c)))) continue;
            accept = true;
        } while (!accept);
        return x / lambda;
    }

    public static double rBeta(double shape1, double shape2) {
        double gam1 = UncommonDistributions.rGamma(shape1, 1.0);
        double gam2 = UncommonDistributions.rGamma(shape2, 1.0);
        return gam1 / (gam1 + gam2);
    }

    public static double rNorm(double mean, double sd) {
        NormalDistribution dist = new NormalDistribution(RANDOM.getRandomGenerator(), mean, sd, 1.0E-9);
        return dist.sample();
    }

    public static int rBinomial(int n, double p) {
        if (p >= 1.0) {
            return n;
        }
        double q = -Math.log1p(-p);
        double sum = 0.0;
        int x = 0;
        while (sum <= q) {
            double u = RANDOM.nextDouble();
            double e = -Math.log(u);
            sum += e / (double)(n - x);
            ++x;
        }
        if (x == 0) {
            return 0;
        }
        return x - 1;
    }
}

