/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.canopy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.canopy.CanopyClusterer;
import org.apache.mahout.clustering.canopy.CanopyConfigKeys;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class CanopyReducer
extends Reducer<Text, VectorWritable, Text, ClusterWritable> {
    private final Collection<Canopy> canopies = Lists.newArrayList();
    private CanopyClusterer canopyClusterer;
    private int clusterFilter;

    CanopyClusterer getCanopyClusterer() {
        return this.canopyClusterer;
    }

    protected void reduce(Text arg0, Iterable<VectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        for (VectorWritable value : values) {
            Vector point = value.get();
            this.canopyClusterer.addPointToCanopies(point, this.canopies);
        }
        for (Canopy canopy : this.canopies) {
            canopy.computeParameters();
            if (canopy.getNumObservations() <= (long)this.clusterFilter) continue;
            ClusterWritable clusterWritable = new ClusterWritable();
            clusterWritable.setValue(canopy);
            context.write((Object)new Text(canopy.getIdentifier()), (Object)clusterWritable);
        }
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.canopyClusterer = CanopyConfigKeys.configureCanopyClusterer(context.getConfiguration());
        this.canopyClusterer.useT3T4();
        this.clusterFilter = Integer.parseInt(context.getConfiguration().get("org.apache.mahout.clustering.canopy.canopyFilter"));
    }
}

