/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import java.util.Collection;
import java.util.List;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class FuzzyKMeansClusterer {
    private static final double MINIMAL_VALUE = 1.0E-10;
    private double m = 2.0;

    public Vector computePi(Collection<SoftCluster> clusters, List<Double> clusterDistanceList) {
        DenseVector pi = new DenseVector(clusters.size());
        for (int i = 0; i < clusters.size(); ++i) {
            double probWeight = this.computeProbWeight(clusterDistanceList.get(i), clusterDistanceList);
            pi.set(i, probWeight);
        }
        return pi;
    }

    public double computeProbWeight(double clusterDistance, Iterable<Double> clusterDistanceList) {
        if (clusterDistance == 0.0) {
            clusterDistance = 1.0E-10;
        }
        double denom = 0.0;
        for (double eachCDist : clusterDistanceList) {
            if (eachCDist == 0.0) {
                eachCDist = 1.0E-10;
            }
            denom += Math.pow(clusterDistance / eachCDist, 2.0 / (this.m - 1.0));
        }
        return 1.0 / denom;
    }

    public void setM(double m) {
        this.m = m;
    }
}

