/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.cluster;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;
import org.apache.mahout.math.random.WeightedThing;

public class StreamingKMeans
implements Iterable<Centroid> {
    private final UpdatableSearcher centroids;
    private int numClusters;
    private int numProcessedDatapoints = 0;
    private double distanceCutoff;
    private final double beta;
    private final double clusterLogFactor;
    private final double clusterOvershoot;
    private final Random random = RandomUtils.getRandom();

    public StreamingKMeans(UpdatableSearcher searcher, int numClusters) {
        this(searcher, numClusters, 1.0 / (double)numClusters, 1.3, 20.0, 2.0);
    }

    public StreamingKMeans(UpdatableSearcher searcher, int numClusters, double distanceCutoff) {
        this(searcher, numClusters, distanceCutoff, 1.3, 20.0, 2.0);
    }

    public StreamingKMeans(UpdatableSearcher searcher, int numClusters, double distanceCutoff, double beta, double clusterLogFactor, double clusterOvershoot) {
        this.centroids = searcher;
        this.numClusters = numClusters;
        this.distanceCutoff = distanceCutoff;
        this.beta = beta;
        this.clusterLogFactor = clusterLogFactor;
        this.clusterOvershoot = clusterOvershoot;
    }

    @Override
    public Iterator<Centroid> iterator() {
        return Iterators.transform(this.centroids.iterator(), (Function)new Function<Vector, Centroid>(){

            public Centroid apply(Vector input) {
                return (Centroid)input;
            }
        });
    }

    public UpdatableSearcher cluster(Matrix data) {
        return this.cluster(Iterables.transform((Iterable)data, (Function)new Function<MatrixSlice, Centroid>(){

            public Centroid apply(MatrixSlice input) {
                return Centroid.create((int)input.index(), (Vector)input.vector());
            }
        }));
    }

    public UpdatableSearcher cluster(Iterable<Centroid> datapoints) {
        return this.clusterInternal(datapoints, false);
    }

    public UpdatableSearcher cluster(final Centroid datapoint) {
        return this.cluster(new Iterable<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    private boolean accessed = false;

                    @Override
                    public boolean hasNext() {
                        return !this.accessed;
                    }

                    @Override
                    public Centroid next() {
                        this.accessed = true;
                        return datapoint;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public int getNumClusters() {
        return this.centroids.size();
    }

    private UpdatableSearcher clusterInternal(Iterable<Centroid> datapoints, boolean collapseClusters) {
        Iterator<Centroid> datapointsIterator = datapoints.iterator();
        if (!datapointsIterator.hasNext()) {
            return this.centroids;
        }
        int oldNumProcessedDataPoints = this.numProcessedDatapoints;
        if (collapseClusters) {
            this.centroids.clear();
            this.numProcessedDatapoints = 0;
        }
        if (this.centroids.size() == 0) {
            this.centroids.add((Vector)datapointsIterator.next().clone());
            ++this.numProcessedDatapoints;
        }
        while (datapointsIterator.hasNext()) {
            Centroid row = datapointsIterator.next();
            WeightedThing<Vector> closestPair = this.centroids.searchFirst((Vector)row, false);
            double sample = this.random.nextDouble();
            if (sample < row.getWeight() * closestPair.getWeight() / this.distanceCutoff) {
                this.centroids.add((Vector)row.clone());
            } else {
                Centroid centroid = (Centroid)closestPair.getValue();
                if (!this.centroids.remove((Vector)centroid, 1.0E-6)) {
                    throw new RuntimeException("Unable to remove centroid");
                }
                centroid.update((Vector)row);
                this.centroids.add((Vector)centroid);
            }
            ++this.numProcessedDatapoints;
            if (collapseClusters || !((double)this.centroids.size() > this.clusterOvershoot * (double)this.numClusters)) continue;
            this.numClusters = (int)Math.max((double)this.numClusters, this.clusterLogFactor * Math.log(this.numProcessedDatapoints));
            ArrayList shuffled = Lists.newArrayList();
            for (Vector vector : this.centroids) {
                shuffled.add((Centroid)vector);
            }
            Collections.shuffle(shuffled);
            this.clusterInternal(shuffled, true);
            if (this.centroids.size() <= this.numClusters) continue;
            this.distanceCutoff *= this.beta;
        }
        if (collapseClusters) {
            this.numProcessedDatapoints = oldNumProcessedDataPoints;
        }
        return this.centroids;
    }

    public void reindexCentroids() {
        int numCentroids = 0;
        for (Centroid centroid : this) {
            centroid.setIndex(numCentroids++);
        }
    }

    public double getDistanceCutoff() {
        return this.distanceCutoff;
    }

    public void setDistanceCutoff(double distanceCutoff) {
        this.distanceCutoff = distanceCutoff;
    }

    public DistanceMeasure getDistanceMeasure() {
        return this.centroids.getDistanceMeasure();
    }
}

