/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;

public class AggregatorReducer
extends Reducer<Text, TopKStringPatterns, Text, TopKStringPatterns> {
    private int maxHeapSize = 50;

    protected void reduce(Text key, Iterable<TopKStringPatterns> values, Reducer.Context context) throws IOException, InterruptedException {
        TopKStringPatterns patterns = new TopKStringPatterns();
        for (TopKStringPatterns value : values) {
            context.setStatus("Aggregator Reducer: Selecting TopK patterns for: " + key);
            patterns = patterns.merge(value, this.maxHeapSize);
        }
        context.write((Object)key, (Object)patterns);
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("pfp.parameters", ""));
        this.maxHeapSize = Integer.valueOf(params.get("maxHeapSize", "50"));
    }
}

