/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Stack;
import org.apache.mahout.common.Pair;
import org.apache.mahout.fpm.pfpgrowth.TransactionTree;
import org.apache.mahout.math.list.IntArrayList;

final class TransactionTreeIterator
extends AbstractIterator<Pair<IntArrayList, Long>> {
    private final Stack<int[]> depth = new Stack();
    private final TransactionTree transactionTree;

    TransactionTreeIterator(TransactionTree transactionTree) {
        this.transactionTree = transactionTree;
        this.depth.push(new int[]{0, -1});
    }

    protected Pair<IntArrayList, Long> computeNext() {
        int childId;
        long sum;
        if (this.depth.isEmpty()) {
            return (Pair)this.endOfData();
        }
        do {
            int[] top = this.depth.peek();
            while (top[1] + 1 == this.transactionTree.childCount(top[0])) {
                this.depth.pop();
                top = this.depth.peek();
            }
            if (this.depth.isEmpty()) {
                return (Pair)this.endOfData();
            }
            top[1] = top[1] + 1;
            childId = this.transactionTree.childAtIndex(top[0], top[1]);
            this.depth.push(new int[]{childId, -1});
            sum = 0L;
            for (int i = this.transactionTree.childCount(childId) - 1; i >= 0; --i) {
                sum += this.transactionTree.count(this.transactionTree.childAtIndex(childId, i));
            }
        } while (sum == this.transactionTree.count(childId));
        Iterator it = this.depth.iterator();
        it.next();
        IntArrayList data = new IntArrayList();
        while (it.hasNext()) {
            data.add(this.transactionTree.attribute(((int[])it.next())[0]));
        }
        Pair<IntArrayList, Long> returnable = new Pair<IntArrayList, Long>(data, this.transactionTree.count(childId) - sum);
        int[] top = this.depth.peek();
        while (top[1] + 1 == this.transactionTree.childCount(top[0])) {
            this.depth.pop();
            if (this.depth.isEmpty()) break;
            top = this.depth.peek();
        }
        return returnable;
    }
}

