/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.convertors;

import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapreduce.Reducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextWriteOutputCollector<IK extends Writable, IV extends Writable, K extends Writable, V extends Writable>
implements OutputCollector<K, V> {
    private static final Logger log = LoggerFactory.getLogger(ContextWriteOutputCollector.class);
    private final Reducer.Context context;

    public ContextWriteOutputCollector(Reducer.Context context) {
        this.context = context;
    }

    public final void collect(K key, V value) throws IOException {
        try {
            this.context.setStatus("Writing Top K patterns for: " + key);
            this.context.write(key, value);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.toString());
        }
    }
}

