/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FPTree;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.LeastKCache;

public class FPTreeDepthCache {
    private final LeastKCache<Integer, FPTree> firstLevelCache = new LeastKCache(5);
    private int hits;
    private int misses;
    private final List<FPTree> treeCache = Lists.newArrayList();

    public final FPTree getFirstLevelTree(Integer attr) {
        FPTree tree = this.firstLevelCache.get(attr);
        if (tree != null) {
            ++this.hits;
            return tree;
        }
        ++this.misses;
        FPTree conditionalTree = new FPTree();
        this.firstLevelCache.set(attr, conditionalTree);
        return conditionalTree;
    }

    public final int getHits() {
        return this.hits;
    }

    public final int getMisses() {
        return this.misses;
    }

    public final FPTree getTree(int level) {
        while (this.treeCache.size() < level + 1) {
            FPTree cTree = new FPTree();
            this.treeCache.add(cTree);
        }
        FPTree conditionalTree = this.treeCache.get(level);
        conditionalTree.clear();
        return conditionalTree;
    }
}

