/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth2;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.mahout.common.Pair;
import org.apache.mahout.fpm.pfpgrowth.convertors.TopKPatternsOutputConverter;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FrequentPatternMaxHeap;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.Pattern;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth2.FPTree;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FPGrowthIds {
    private static final Logger log = LoggerFactory.getLogger(FPGrowthIds.class);

    private FPGrowthIds() {
    }

    public static void generateTopKFrequentPatterns(Iterator<Pair<IntArrayList, Long>> transactionStream, LongArrayList attributeFrequency, long minSupport, int k, IntArrayList returnableFeatures, OutputCollector<Integer, List<Pair<List<Integer>, Long>>> output) throws IOException {
        for (int i = 0; i < attributeFrequency.size(); ++i) {
            if (attributeFrequency.get(i) >= minSupport) continue;
            attributeFrequency.setSize(i);
            attributeFrequency.trimToSize();
            break;
        }
        log.info("Number of unique items {}", (Object)attributeFrequency.size());
        if (returnableFeatures == null || returnableFeatures.isEmpty()) {
            returnableFeatures = new IntArrayList();
            for (int j = 0; j < attributeFrequency.size(); ++j) {
                returnableFeatures.add(j);
            }
        }
        log.info("Number of unique pruned items {}", (Object)attributeFrequency.size());
        FPGrowthIds.generateTopKFrequentPatterns(transactionStream, attributeFrequency, minSupport, k, returnableFeatures, new TopKPatternsOutputConverter<Integer>(output, new IdentityMapping()));
    }

    private static Map<Integer, FrequentPatternMaxHeap> fpGrowth(FPTree tree, long minSupportValue, int k, IntArrayList requiredFeatures, TopKPatternsOutputConverter<Integer> outputCollector) throws IOException {
        HashMap patterns = Maps.newHashMap();
        requiredFeatures.sort();
        for (int attribute : tree.attrIterableRev()) {
            if (requiredFeatures.binarySearch(attribute) < 0) continue;
            log.info("Mining FTree Tree for all patterns with {}", (Object)attribute);
            MutableLong minSupport = new MutableLong(minSupportValue);
            FrequentPatternMaxHeap frequentPatterns = FPGrowthIds.growth(tree, minSupport, k, attribute);
            patterns.put(attribute, frequentPatterns);
            outputCollector.collect(attribute, frequentPatterns);
            minSupportValue = Math.max(minSupportValue, minSupport.longValue() / 2L);
            log.info("Found {} Patterns with Least Support {}", (Object)((FrequentPatternMaxHeap)patterns.get(attribute)).count(), (Object)((FrequentPatternMaxHeap)patterns.get(attribute)).leastSupport());
        }
        return patterns;
    }

    private static void generateTopKFrequentPatterns(Iterator<Pair<IntArrayList, Long>> transactions, LongArrayList attributeFrequency, long minSupport, int k, IntArrayList returnFeatures, TopKPatternsOutputConverter<Integer> topKPatternsOutputCollector) throws IOException {
        FPTree tree = new FPTree(attributeFrequency, minSupport);
        int i = 0;
        while (transactions.hasNext()) {
            Pair<IntArrayList, Long> transaction = transactions.next();
            IntArrayList iArr = transaction.getFirst();
            tree.accumulate(iArr, (long)transaction.getSecond());
            if (++i % 10000 != 0) continue;
            log.info("FPTree Building: Read {} Transactions", (Object)i);
        }
        FPGrowthIds.fpGrowth(tree, minSupport, k, returnFeatures, topKPatternsOutputCollector);
    }

    private static FrequentPatternMaxHeap growth(FPTree tree, MutableLong minSupportMutable, int k, int currentAttribute) {
        long currentAttributeCount = tree.headerCount(currentAttribute);
        if (currentAttributeCount < minSupportMutable.longValue()) {
            return new FrequentPatternMaxHeap(k, true);
        }
        FPTree condTree = tree.createMoreFreqConditionalTree(currentAttribute);
        Pair<FPTree, FPTree> pAndQ = condTree.splitSinglePrefix();
        FPTree p = pAndQ.getFirst();
        FPTree q = pAndQ.getSecond();
        FrequentPatternMaxHeap prefixPats = null;
        if (p != null) {
            prefixPats = FPGrowthIds.mineSinglePrefix(p, k);
        }
        FrequentPatternMaxHeap suffixPats = new FrequentPatternMaxHeap(k, true);
        Pattern thisPat = new Pattern();
        thisPat.add(currentAttribute, currentAttributeCount);
        suffixPats.insert(thisPat);
        for (int attr : q.attrIterableRev()) {
            FPGrowthIds.mergeHeap(suffixPats, FPGrowthIds.growth(q, minSupportMutable, k, attr), currentAttribute, currentAttributeCount, true);
        }
        if (prefixPats != null) {
            return FPGrowthIds.cross(prefixPats, suffixPats, k);
        }
        return suffixPats;
    }

    private static FrequentPatternMaxHeap cross(FrequentPatternMaxHeap pPats, FrequentPatternMaxHeap qPats, int k) {
        FrequentPatternMaxHeap pats = new FrequentPatternMaxHeap(k, true);
        for (Pattern p : pPats.getHeap()) {
            int[] pints = p.getPattern();
            for (Pattern q : qPats.getHeap()) {
                int[] qints = q.getPattern();
                Pattern pq = new Pattern();
                for (int pi = 0; pi < p.length(); ++pi) {
                    pq.add(pints[pi], p.support());
                }
                for (int qi = 0; qi < q.length(); ++qi) {
                    pq.add(qints[qi], q.support());
                }
                pats.insert(pq);
            }
        }
        for (Pattern q : qPats.getHeap()) {
            Pattern qq = new Pattern();
            int[] qints = q.getPattern();
            for (int qi = 0; qi < q.length(); ++qi) {
                qq.add(qints[qi], q.support());
            }
            pats.insert(qq);
        }
        return pats;
    }

    private static FrequentPatternMaxHeap mineSinglePrefix(FPTree tree, int k) {
        FrequentPatternMaxHeap pats = new FrequentPatternMaxHeap(k, true);
        FPTree.FPNode currNode = tree.root();
        while (currNode.numChildren() == 1) {
            currNode = currNode.children().iterator().next();
            FrequentPatternMaxHeap singlePat = new FrequentPatternMaxHeap(k, true);
            Pattern p = new Pattern();
            p.add(currNode.attribute(), currNode.count());
            singlePat.insert(p);
            pats = FPGrowthIds.cross(singlePat, pats, k);
            pats.insert(p);
        }
        return pats;
    }

    private static void mergeHeap(FrequentPatternMaxHeap frequentPatterns, FrequentPatternMaxHeap returnedPatterns, int attribute, long count, boolean addAttribute) {
        frequentPatterns.addAll(returnedPatterns, attribute, count);
        if (frequentPatterns.addable(count) && addAttribute) {
            Pattern p = new Pattern();
            p.add(attribute, count);
            frequentPatterns.insert(p);
        }
    }

    private static class IdentityMapping
    extends AbstractMap<Integer, Integer> {
        private IdentityMapping() {
        }

        @Override
        public Set<Map.Entry<Integer, Integer>> entrySet() {
            throw new IllegalStateException();
        }

        @Override
        public Integer get(Object key) {
            return (Integer)key;
        }
    }
}

