/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Varint;
import org.apache.mahout.math.Vector;

public final class VectorWritable
extends Configured
implements Writable {
    public static final int FLAG_DENSE = 1;
    public static final int FLAG_SEQUENTIAL = 2;
    public static final int FLAG_NAMED = 4;
    public static final int FLAG_LAX_PRECISION = 8;
    public static final int NUM_FLAGS = 4;
    private Vector vector;
    private boolean writesLaxPrecision;

    public VectorWritable() {
    }

    public VectorWritable(boolean writesLaxPrecision) {
        this.setWritesLaxPrecision(writesLaxPrecision);
    }

    public VectorWritable(Vector vector) {
        this.vector = vector;
    }

    public VectorWritable(Vector vector, boolean writesLaxPrecision) {
        this(vector);
        this.setWritesLaxPrecision(writesLaxPrecision);
    }

    public Vector get() {
        return this.vector;
    }

    public void set(Vector vector) {
        this.vector = vector;
    }

    public boolean isWritesLaxPrecision() {
        return this.writesLaxPrecision;
    }

    public void setWritesLaxPrecision(boolean writesLaxPrecision) {
        this.writesLaxPrecision = writesLaxPrecision;
    }

    public void write(DataOutput out) throws IOException {
        VectorWritable.writeVector(out, this.vector, this.writesLaxPrecision);
    }

    public void readFields(DataInput in) throws IOException {
        SequentialAccessSparseVector v;
        byte flags = in.readByte();
        Preconditions.checkArgument((flags >> 4 == 0 ? 1 : 0) != 0, (String)"Unknown flags set: %d", (Object[])new Object[]{Integer.toString(flags, 2)});
        boolean dense = (flags & 1) != 0;
        boolean sequential = (flags & 2) != 0;
        boolean named = (flags & 4) != 0;
        boolean laxPrecision = (flags & 8) != 0;
        int size = Varint.readUnsignedVarInt(in);
        if (dense) {
            double[] values = new double[size];
            for (int i = 0; i < size; ++i) {
                values[i] = laxPrecision ? (double)in.readFloat() : in.readDouble();
            }
            v = new DenseVector(values);
        } else {
            int numNonDefaultElements = Varint.readUnsignedVarInt(in);
            Object object = v = sequential ? new SequentialAccessSparseVector(size, numNonDefaultElements) : new RandomAccessSparseVector(size, numNonDefaultElements);
            if (sequential) {
                int lastIndex = 0;
                for (int i = 0; i < numNonDefaultElements; ++i) {
                    int index;
                    int delta = Varint.readUnsignedVarInt(in);
                    lastIndex = index = lastIndex + delta;
                    double value = laxPrecision ? (double)in.readFloat() : in.readDouble();
                    v.setQuick(index, value);
                }
            } else {
                for (int i = 0; i < numNonDefaultElements; ++i) {
                    int index = Varint.readUnsignedVarInt(in);
                    double value = laxPrecision ? (double)in.readFloat() : in.readDouble();
                    v.setQuick(index, value);
                }
            }
        }
        if (named) {
            String name = in.readUTF();
            v = new NamedVector((Vector)v, name);
        }
        this.vector = v;
    }

    public static void writeVector(DataOutput out, Vector vector) throws IOException {
        VectorWritable.writeVector(out, vector, false);
    }

    public static void writeVector(DataOutput out, Vector vector, boolean laxPrecision) throws IOException {
        boolean dense = vector.isDense();
        boolean sequential = vector.isSequentialAccess();
        boolean named = vector instanceof NamedVector;
        out.writeByte((dense ? 1 : 0) | (sequential ? 2 : 0) | (named ? 4 : 0) | (laxPrecision ? 8 : 0));
        Varint.writeUnsignedVarInt(vector.size(), out);
        if (dense) {
            for (Vector.Element element : vector.all()) {
                if (laxPrecision) {
                    out.writeFloat((float)element.get());
                    continue;
                }
                out.writeDouble(element.get());
            }
        } else {
            Varint.writeUnsignedVarInt(vector.getNumNonZeroElements(), out);
            Iterator iter = vector.nonZeroes().iterator();
            if (sequential) {
                int lastIndex = 0;
                while (iter.hasNext()) {
                    Vector.Element element = (Vector.Element)iter.next();
                    if (element.get() == 0.0) continue;
                    int thisIndex = element.index();
                    Varint.writeUnsignedVarInt(thisIndex - lastIndex, out);
                    lastIndex = thisIndex;
                    if (laxPrecision) {
                        out.writeFloat((float)element.get());
                        continue;
                    }
                    out.writeDouble(element.get());
                }
            } else {
                while (iter.hasNext()) {
                    Vector.Element element = (Vector.Element)iter.next();
                    if (element.get() == 0.0) continue;
                    Varint.writeUnsignedVarInt(element.index(), out);
                    if (laxPrecision) {
                        out.writeFloat((float)element.get());
                        continue;
                    }
                    out.writeDouble(element.get());
                }
            }
        }
        if (named) {
            String name = ((NamedVector)vector).getName();
            out.writeUTF(name == null ? "" : name);
        }
    }

    public static Vector readVector(DataInput in) throws IOException {
        VectorWritable v = new VectorWritable();
        v.readFields(in);
        return v.get();
    }

    public static VectorWritable merge(Iterator<VectorWritable> vectors) {
        return new VectorWritable(VectorWritable.mergeToVector(vectors));
    }

    public static Vector mergeToVector(Iterator<VectorWritable> vectors) {
        Vector accumulator = vectors.next().get();
        while (vectors.hasNext()) {
            VectorWritable v = vectors.next();
            if (v == null) continue;
            for (Vector.Element nonZeroElement : v.get().nonZeroes()) {
                accumulator.setQuick(nonZeroElement.index(), nonZeroElement.get());
            }
        }
        return accumulator;
    }

    public boolean equals(Object o) {
        return o instanceof VectorWritable && this.vector.equals(((VectorWritable)((Object)o)).get());
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public String toString() {
        return this.vector.toString();
    }
}

