/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.decomposer;

import java.util.regex.Pattern;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;

public class EigenVector
extends NamedVector {
    private static final Pattern EQUAL_PATTERN = Pattern.compile(" = ");
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");

    public EigenVector(Vector v, double eigenValue, double cosAngleError, int order) {
        super((Vector)(v instanceof DenseVector ? (DenseVector)v : new DenseVector(v)), "e|" + order + "| = |" + eigenValue + "|, err = " + cosAngleError);
    }

    public double getEigenValue() {
        return EigenVector.getEigenValue(this.getName());
    }

    public double getCosAngleError() {
        return EigenVector.getCosAngleError(this.getName());
    }

    public int getIndex() {
        return EigenVector.getIndex(this.getName());
    }

    public static double getEigenValue(CharSequence name) {
        return EigenVector.parseMetaData(name)[1];
    }

    public static double getCosAngleError(CharSequence name) {
        return EigenVector.parseMetaData(name)[2];
    }

    public static int getIndex(CharSequence name) {
        return (int)EigenVector.parseMetaData(name)[0];
    }

    public static double[] parseMetaData(CharSequence name) {
        double[] m = new double[3];
        String[] s = EQUAL_PATTERN.split(name);
        m[0] = Double.parseDouble(PIPE_PATTERN.split(s[0])[1]);
        m[1] = Double.parseDouble(PIPE_PATTERN.split(s[1])[1]);
        m[2] = Double.parseDouble(s[2].substring(1));
        return m;
    }

    protected double[] parseMetaData() {
        return EigenVector.parseMetaData(this.getName());
    }
}

