/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.base.Charsets;
import java.util.Locale;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;

public class InteractionValueEncoder
extends FeatureVectorEncoder {
    private final FeatureVectorEncoder firstEncoder;
    private final FeatureVectorEncoder secondEncoder;

    public InteractionValueEncoder(String name, FeatureVectorEncoder encoderOne, FeatureVectorEncoder encoderTwo) {
        super(name, 2);
        this.firstEncoder = encoderOne;
        this.secondEncoder = encoderTwo;
    }

    @Override
    public void addToVector(String originalForm, double w, Vector data) {
        throw new UnsupportedOperationException("addToVector is not supported for InteractionVectorEncoder");
    }

    @Override
    public void addToVector(byte[] originalForm, double w, Vector data) {
        throw new UnsupportedOperationException("addToVector is not supported for InteractionVectorEncoder");
    }

    public void addInteractionToVector(String original1, String original2, double weight, Vector data) {
        byte[] originalForm1 = InteractionValueEncoder.bytesForString(original1);
        byte[] originalForm2 = InteractionValueEncoder.bytesForString(original2);
        this.addInteractionToVector(originalForm1, originalForm2, weight, data);
    }

    public void addInteractionToVector(byte[] originalForm1, byte[] originalForm2, double weight, Vector data) {
        String name = this.getName();
        double w = this.getWeight(originalForm1, originalForm2, weight);
        for (int i = 0; i < this.probes(); ++i) {
            Iterable<Integer> jValues = this.secondEncoder.hashesForProbe(originalForm2, data.size(), name, i % this.secondEncoder.getProbes());
            for (Integer k : this.firstEncoder.hashesForProbe(originalForm1, data.size(), name, i % this.firstEncoder.getProbes())) {
                for (Integer j : jValues) {
                    int n = (k + j) % data.size();
                    if (this.isTraceEnabled()) {
                        this.trace(String.format("%s:%s", new String(originalForm1, Charsets.UTF_8), new String(originalForm2, Charsets.UTF_8)), n);
                    }
                    data.set(n, data.get(n) + w);
                }
            }
        }
    }

    private int probes() {
        return this.getProbes();
    }

    protected double getWeight(byte[] originalForm1, byte[] originalForm2, double w) {
        return this.firstEncoder.getWeight(originalForm1, 1.0) * this.secondEncoder.getWeight(originalForm2, 1.0) * w;
    }

    @Override
    public String asString(String originalForm) {
        return String.format(Locale.ENGLISH, "%s:%s", this.getName(), originalForm);
    }

    @Override
    protected int hashForProbe(byte[] originalForm, int dataSize, String name, int probe) {
        return this.hash(name, probe, dataSize);
    }
}

