/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.web;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecommenderWrapper
implements Recommender {
    private static final Logger log = LoggerFactory.getLogger(RecommenderWrapper.class);
    private final Recommender delegate = this.buildRecommender();

    protected RecommenderWrapper() throws TasteException, IOException {
    }

    protected abstract Recommender buildRecommender() throws IOException, TasteException;

    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.delegate.recommend(userID, howMany);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        return this.delegate.recommend(userID, howMany, rescorer);
    }

    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.delegate.estimatePreference(userID, itemID);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.delegate.setPreference(userID, itemID, value);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.delegate.removePreference(userID, itemID);
    }

    public DataModel getDataModel() {
        return this.delegate.getDataModel();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.delegate.refresh(alreadyRefreshed);
    }

    public static File readResourceToTempFile(String resourceName) throws IOException {
        InputSupplier inSupplier;
        String absoluteResource = resourceName.startsWith("/") ? resourceName : '/' + resourceName;
        log.info("Loading resource {}", (Object)absoluteResource);
        try {
            URL resourceURL = Resources.getResource(RecommenderWrapper.class, (String)absoluteResource);
            inSupplier = Resources.newInputStreamSupplier((URL)resourceURL);
        }
        catch (IllegalArgumentException iae) {
            File resourceFile = new File(resourceName);
            log.info("Falling back to load file {}", (Object)resourceFile.getAbsolutePath());
            inSupplier = Files.newInputStreamSupplier((File)resourceFile);
        }
        File tempFile = File.createTempFile("taste", null);
        tempFile.deleteOnExit();
        Files.copy((InputSupplier)inSupplier, (File)tempFile);
        return tempFile;
    }
}

