/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.mahout.utils.io.ChunkedWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequenceFilesFromDirectoryFilter
implements PathFilter {
    private static final Logger log = LoggerFactory.getLogger(SequenceFilesFromDirectoryFilter.class);
    private final String prefix;
    private final ChunkedWriter writer;
    private final Charset charset;
    private final FileSystem fs;
    private final Map<String, String> options;
    private final Configuration conf;

    protected SequenceFilesFromDirectoryFilter(Configuration conf, String keyPrefix, Map<String, String> options, ChunkedWriter writer, Charset charset, FileSystem fs) {
        this.prefix = keyPrefix;
        this.writer = writer;
        this.charset = charset;
        this.fs = fs;
        this.options = options;
        this.conf = conf;
    }

    protected final String getPrefix() {
        return this.prefix;
    }

    protected final ChunkedWriter getWriter() {
        return this.writer;
    }

    protected final Charset getCharset() {
        return this.charset;
    }

    protected final FileSystem getFs() {
        return this.fs;
    }

    protected final Map<String, String> getOptions() {
        return this.options;
    }

    protected final Configuration getConf() {
        return this.conf;
    }

    public final boolean accept(Path current) {
        log.debug("CURRENT: {}", (Object)current.getName());
        try {
            for (FileStatus fst : this.fs.listStatus(current)) {
                log.debug("CHILD: {}", (Object)fst.getPath().getName());
                this.process(fst, current);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return false;
    }

    protected abstract void process(FileStatus var1, Path var2) throws IOException;
}

