/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.nlp.collocations.llr;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class BloomTokenFilter
extends TokenFilter {
    private final Filter filter;
    private final CharTermAttribute termAtt;
    private final CharsetEncoder encoder;
    private final Key key;
    private final boolean keepMembers;

    public BloomTokenFilter(Filter filter, boolean keepMembers, TokenStream in) {
        super(in);
        this.filter = filter;
        this.keepMembers = keepMembers;
        this.key = new Key();
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.encoder = Charsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            ByteBuffer bytes = this.encoder.encode(CharBuffer.wrap(this.termAtt.buffer(), 0, this.termAtt.length()));
            this.key.set(bytes.array(), 1.0);
            boolean member = this.filter.membershipTest(this.key);
            if ((!this.keepMembers || !member) && (this.keepMembers || member)) continue;
            return true;
        }
        return false;
    }
}

