/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.TimesFunction;
import org.junit.Test;

public final class TestVectorView
extends MahoutTestCase {
    private static final int CARDINALITY = 3;
    private static final int OFFSET = 1;
    private final double[] values = new double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5};
    private final Vector test = new VectorView((Vector)new DenseVector(this.values), 1, 3);

    @Test
    public void testCardinality() {
        TestVectorView.assertEquals((String)"size", (long)3L, (long)this.test.size());
    }

    @Test
    public void testCopy() throws Exception {
        Vector copy = this.test.clone();
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("copy [" + i + ']'), (double)this.test.get(i), (double)copy.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testGet() throws Exception {
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("get [" + i + ']'), (double)this.values[i + 1], (double)this.test.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=IndexException.class)
    public void testGetOver() {
        this.test.get(this.test.size());
    }

    @Test
    public void testIterator() throws Exception {
        VectorView view = new VectorView((Vector)new DenseVector(this.values), 1, 3);
        double[] gold = new double[]{1.1, 2.2, 3.3};
        Iterator iter = view.iterator();
        TestVectorView.checkIterator(iter, gold);
        iter = view.iterateNonZero();
        TestVectorView.checkIterator(iter, gold);
        view = new VectorView((Vector)new DenseVector(this.values), 0, 3);
        gold = new double[]{0.0, 1.1, 2.2};
        iter = view.iterator();
        TestVectorView.checkIterator(iter, gold);
        gold = new double[]{1.1, 2.2};
        iter = view.iterateNonZero();
        TestVectorView.checkIterator(iter, gold);
    }

    private static void checkIterator(Iterator<Vector.Element> iter, double[] gold) {
        int i = 0;
        while (iter.hasNext()) {
            Vector.Element elt = iter.next();
            TestVectorView.assertEquals((String)(elt.index() + " Value: " + gold[i] + " does not equal: " + elt.get()), (double)gold[i], (double)elt.get(), (double)0.0);
            ++i;
        }
    }

    @Test(expected=IndexException.class)
    public void testGetUnder() {
        this.test.get(-1);
    }

    @Test
    public void testSet() throws Exception {
        this.test.set(2, 4.5);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("set [" + i + ']'), (double)(i == 2 ? 4.5 : this.values[1 + i]), (double)this.test.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testSize() throws Exception {
        TestVectorView.assertEquals((String)"size", (long)3L, (long)this.test.getNumNondefaultElements());
    }

    @Test
    public void testViewPart() throws Exception {
        Vector part = this.test.viewPart(1, 2);
        TestVectorView.assertEquals((String)"part size", (long)2L, (long)part.getNumNondefaultElements());
        for (int i = 0; i < part.size(); ++i) {
            TestVectorView.assertEquals((String)("part[" + i + ']'), (double)this.values[1 + i + 1], (double)part.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=IndexException.class)
    public void testViewPartUnder() {
        this.test.viewPart(-1, 3);
    }

    @Test(expected=IndexException.class)
    public void testViewPartOver() {
        this.test.viewPart(2, 3);
    }

    @Test(expected=IndexException.class)
    public void testViewPartCardinality() {
        this.test.viewPart(1, this.values.length + 1);
    }

    @Test
    public void testDot() throws Exception {
        double res = this.test.dot(this.test);
        TestVectorView.assertEquals((String)"dot", (double)16.939999999999998, (double)res, (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testDotCardinality() {
        this.test.dot((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testNormalize() throws Exception {
        Vector res = this.test.normalize();
        double mag = Math.sqrt(16.939999999999998);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)"dot", (double)(this.values[1 + i] / mag), (double)res.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testMinus() throws Exception {
        Vector val = this.test.minus(this.test);
        TestVectorView.assertEquals((String)"size", (long)3L, (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPlusDouble() throws Exception {
        Vector val = this.test.plus(1.0);
        TestVectorView.assertEquals((String)"size", (long)3L, (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("get [" + i + ']'), (double)(this.values[1 + i] + 1.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPlusVector() throws Exception {
        Vector val = this.test.plus(this.test);
        TestVectorView.assertEquals((String)"size", (long)3L, (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("get [" + i + ']'), (double)(this.values[1 + i] * 2.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testPlusVectorCardinality() {
        this.test.plus((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testTimesDouble() throws Exception {
        Vector val = this.test.times(3.0);
        TestVectorView.assertEquals((String)"size", (long)3L, (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("get [" + i + ']'), (double)(this.values[1 + i] * 3.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testDivideDouble() throws Exception {
        Vector val = this.test.divide(3.0);
        TestVectorView.assertEquals((String)"size", (long)3L, (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("get [" + i + ']'), (double)(this.values[1 + i] / 3.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testTimesVector() throws Exception {
        Vector val = this.test.times(this.test);
        TestVectorView.assertEquals((String)"size", (long)3L, (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("get [" + i + ']'), (double)(this.values[1 + i] * this.values[1 + i]), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testTimesVectorCardinality() {
        this.test.times((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testZSum() {
        double expected = 0.0;
        for (int i = 1; i < 4; ++i) {
            expected += this.values[i];
        }
        TestVectorView.assertEquals((String)"wrong zSum", (double)expected, (double)this.test.zSum(), (double)1.0E-6);
    }

    @Test
    public void testAssignDouble() {
        this.test.assign(0.0);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignDoubleArray() throws Exception {
        double[] array = new double[this.test.size()];
        this.test.assign(array);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignDoubleArrayCardinality() {
        double[] array = new double[this.test.size() + 1];
        this.test.assign(array);
    }

    @Test
    public void testAssignVector() throws Exception {
        DenseVector other = new DenseVector(this.test.size());
        this.test.assign((Vector)other);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignVectorCardinality() {
        DenseVector other = new DenseVector(this.test.size() - 1);
        this.test.assign((Vector)other);
    }

    @Test
    public void testAssignUnaryFunction() {
        this.test.assign(Functions.NEGATE);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("value[" + i + ']'), (double)(-this.values[i + 1]), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction() throws Exception {
        this.test.assign(this.test, Functions.PLUS);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("value[" + i + ']'), (double)(2.0 * this.values[i + 1]), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction2() throws Exception {
        this.test.assign(Functions.PLUS, 4.0);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("value[" + i + ']'), (double)(this.values[i + 1] + 4.0), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction3() throws Exception {
        this.test.assign((DoubleDoubleFunction)new TimesFunction(), 4.0);
        for (int i = 0; i < this.test.size(); ++i) {
            TestVectorView.assertEquals((String)("value[" + i + ']'), (double)(this.values[i + 1] * 4.0), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testLike() {
        TestVectorView.assertTrue((String)"not like", (boolean)(this.test.like() instanceof VectorView));
    }

    @Test
    public void testCrossProduct() {
        Matrix result = this.test.cross(this.test);
        TestVectorView.assertEquals((String)"row size", (long)this.test.size(), (long)result.rowSize());
        TestVectorView.assertEquals((String)"col size", (long)this.test.size(), (long)result.columnSize());
        for (int row = 0; row < result.rowSize(); ++row) {
            for (int col = 0; col < result.columnSize(); ++col) {
                TestVectorView.assertEquals((String)("cross[" + row + "][" + col + ']'), (double)(this.test.getQuick(row) * this.test.getQuick(col)), (double)result.getQuick(row, col), (double)1.0E-6);
            }
        }
    }
}

