/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorBinaryAssign;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class VectorBinaryAssignTest {
    private static final int CARDINALITY = 10;
    private DoubleDoubleFunction function;
    private VectorBinaryAssign operation;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        ArrayList data = Lists.newArrayList();
        for (List entry : Sets.cartesianProduct((List)Lists.newArrayList((Object[])new ImmutableSet[]{ImmutableSet.of((Object)Functions.PLUS, (Object)Functions.PLUS_ABS, (Object)Functions.MULT, (Object)Functions.MULT_RIGHT_PLUS1, (Object)Functions.MINUS), ImmutableSet.copyOf((Object[])VectorBinaryAssign.OPERATIONS)}))) {
            data.add(entry.toArray());
        }
        return data;
    }

    public VectorBinaryAssignTest(DoubleDoubleFunction function, VectorBinaryAssign operation) {
        this.function = function;
        this.operation = operation;
    }

    @Test
    public void testAll() {
        SequentialAccessSparseVector x = new SequentialAccessSparseVector(10);
        for (int i = 0; i < x.size(); ++i) {
            x.setQuick(i, (double)i);
        }
        SequentialAccessSparseVector y = new SequentialAccessSparseVector(x);
        System.out.printf("function %s; operation %s\n", this.function, this.operation);
        this.operation.assign((Vector)x, (Vector)y, this.function);
        for (int i = 0; i < x.size(); ++i) {
            Assert.assertEquals((double)x.getQuick(i), (double)this.function.apply((double)i, (double)i), (double)0.0);
        }
    }
}

