/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.lanczos.LanczosState;
import org.apache.mahout.math.function.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolverTest
extends MahoutTestCase {
    private static final Logger log = LoggerFactory.getLogger(SolverTest.class);

    public static void assertOrthonormal(Matrix eigens) {
        SolverTest.assertOrthonormal(eigens, 1.0E-6);
    }

    public static void assertOrthonormal(Matrix currentEigens, double errorMargin) {
        ArrayList nonOrthogonals = Lists.newArrayList();
        for (int i = 0; i < currentEigens.numRows(); ++i) {
            Vector ei = currentEigens.viewRow(i);
            for (int j = 0; j <= i; ++j) {
                Vector ej = currentEigens.viewRow(j);
                if (ei.norm(2.0) == 0.0 || ej.norm(2.0) == 0.0) continue;
                double dot = ei.dot(ej);
                if (i == j) {
                    SolverTest.assertTrue((String)("not norm 1 : " + dot + " (eigen #" + i + ')'), (Math.abs(1.0 - dot) < errorMargin ? 1 : 0) != 0);
                    continue;
                }
                if (!(Math.abs(dot) > errorMargin)) continue;
                log.info("not orthogonal : {} (eigens {}, {})", new Object[]{dot, i, j});
                nonOrthogonals.add("(" + i + ',' + j + ')');
            }
            log.info("{}:{}", (Object)nonOrthogonals.size(), (Object)nonOrthogonals);
        }
    }

    public static void assertOrthonormal(LanczosState state) {
        double errorMargin = 1.0E-5;
        ArrayList nonOrthogonals = Lists.newArrayList();
        for (int i = 0; i < state.getIterationNumber(); ++i) {
            Vector ei = state.getRightSingularVector(i);
            for (int j = 0; j <= i; ++j) {
                Vector ej = state.getRightSingularVector(j);
                if (ei.norm(2.0) == 0.0 || ej.norm(2.0) == 0.0) continue;
                double dot = ei.dot(ej);
                if (i == j) {
                    SolverTest.assertTrue((String)("not norm 1 : " + dot + " (eigen #" + i + ')'), (Math.abs(1.0 - dot) < errorMargin ? 1 : 0) != 0);
                    continue;
                }
                if (!(Math.abs(dot) > errorMargin)) continue;
                log.info("not orthogonal : {} (eigens {}, {})", new Object[]{dot, i, j});
                nonOrthogonals.add("(" + i + ',' + j + ')');
            }
            if (nonOrthogonals.isEmpty()) continue;
            log.info("{}:{}", (Object)nonOrthogonals.size(), (Object)nonOrthogonals);
        }
    }

    public static void assertEigen(Matrix eigens, VectorIterable corpus, double errorMargin, boolean isSymmetric) {
        SolverTest.assertEigen(eigens, corpus, eigens.numRows(), errorMargin, isSymmetric);
    }

    public static void assertEigen(Matrix eigens, VectorIterable corpus, int numEigensToCheck, double errorMargin, boolean isSymmetric) {
        for (int i = 0; i < numEigensToCheck; ++i) {
            Vector e = eigens.viewRow(i);
            SolverTest.assertEigen(i, e, corpus, errorMargin, isSymmetric);
        }
    }

    public static void assertEigen(int i, Vector e, VectorIterable corpus, double errorMargin, boolean isSymmetric) {
        if (e.getLengthSquared() == 0.0) {
            return;
        }
        Vector afterMultiply = isSymmetric ? corpus.times(e) : corpus.timesSquared(e);
        double dot = afterMultiply.dot(e);
        double afterNorm = afterMultiply.getLengthSquared();
        double error = 1.0 - Math.abs(dot / Math.sqrt(afterNorm * e.getLengthSquared()));
        log.info("the eigen-error: {} for eigen {}", (Object)error, (Object)i);
        SolverTest.assertTrue((String)("Error: {" + error + " too high! (for eigen " + i + ')'), (Math.abs(error) < errorMargin ? 1 : 0) != 0);
    }

    public static Matrix randomSequentialAccessSparseMatrix(int numRows, int nonNullRows, int numCols, int entriesPerRow, double entryMean) {
        SparseRowMatrix m = new SparseRowMatrix(numRows, numCols);
        RandomWrapper r = RandomUtils.getRandom();
        for (int i = 0; i < nonNullRows; ++i) {
            SequentialAccessSparseVector v = new SequentialAccessSparseVector(numCols);
            for (int j = 0; j < entriesPerRow; ++j) {
                int col = r.nextInt(numCols);
                double val = r.nextGaussian();
                v.set(col, val * entryMean);
            }
            int c = r.nextInt(numRows);
            if (r.nextBoolean() || numRows == nonNullRows) {
                m.assignRow(numRows == nonNullRows ? i : c, (Vector)v);
                continue;
            }
            Vector other = m.viewRow(r.nextInt(numRows));
            if (other == null || !(other.getLengthSquared() > 0.0)) continue;
            m.assignRow(c, other.clone());
        }
        return m;
    }

    public static Matrix randomHierarchicalMatrix(int numRows, int numCols, boolean symmetric) {
        DenseMatrix matrix = new DenseMatrix(numRows, numCols);
        Random r = new Random(1234L);
        for (int row = 0; row < numRows; ++row) {
            DenseVector v = new DenseVector(numCols);
            for (int col = 0; col < numCols; ++col) {
                double val = r.nextGaussian();
                v.set(col, val);
            }
            v.assign(Functions.MULT, 1.0 / ((double)(row + 1) * v.norm(2.0)));
            matrix.assignRow(row, (Vector)v);
        }
        if (symmetric) {
            return matrix.times(matrix.transpose());
        }
        return matrix;
    }

    public static Matrix randomHierarchicalSymmetricMatrix(int size) {
        return SolverTest.randomHierarchicalMatrix(size, size, true);
    }
}

