/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.AbstractCharList;
import org.apache.mahout.math.list.CharArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CharArrayListTest
extends Assert {
    private CharArrayList emptyList;
    private CharArrayList listOfFive;

    @Before
    public void before() {
        this.emptyList = new CharArrayList();
        this.listOfFive = new CharArrayList();
        for (int x = 0; x < 5; ++x) {
            this.listOfFive.add((char)x);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEmpty() {
        this.emptyList.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setEmpty() {
        this.emptyList.set(1, '\u0001');
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void beforeInsertInvalidRange() {
        this.emptyList.beforeInsert(1, '\u0000');
    }

    @Test
    public void testAdd() {
        int x;
        this.emptyList.add('\f');
        CharArrayListTest.assertEquals((long)1L, (long)this.emptyList.size());
        for (x = 0; x < 1000; ++x) {
            this.emptyList.add((char)(x % 65535));
        }
        CharArrayListTest.assertEquals((long)1001L, (long)this.emptyList.size());
        CharArrayListTest.assertEquals((long)12L, (long)this.emptyList.get(0));
        for (x = 0; x < 1000; ++x) {
            CharArrayListTest.assertEquals((long)((char)(x % 65535)), (long)this.emptyList.get(x + 1));
        }
    }

    @Test
    public void testBinarySearch() {
        int x = this.listOfFive.binarySearchFromTo('\u0000', 2, 4);
        CharArrayListTest.assertEquals((long)-3L, (long)x);
        x = this.listOfFive.binarySearchFromTo('\u0001', 0, 4);
        CharArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testClone() {
        CharArrayList l2 = this.listOfFive.copy();
        CharArrayListTest.assertNotSame((Object)this.listOfFive, (Object)l2);
        CharArrayListTest.assertEquals((Object)this.listOfFive, (Object)l2);
    }

    @Test
    public void testElements() {
        char[] l = new char[]{'\f', '\u0018', '$', '0'};
        CharArrayList lar = new CharArrayList(l);
        CharArrayListTest.assertEquals((long)4L, (long)lar.size());
        CharArrayListTest.assertSame((Object)l, (Object)lar.elements());
        char[] l2 = new char[]{'\u0003', '\u0006', '\t', '\f'};
        lar.elements(l2);
        CharArrayListTest.assertSame((Object)l2, (Object)lar.elements());
    }

    @Test
    public void testEquals() {
        char[] l = new char[]{'\f', '\u0018', '$', '0'};
        CharArrayList lar = new CharArrayList(l);
        CharArrayList lar2 = new CharArrayList();
        for (int x = 0; x < lar.size(); ++x) {
            lar2.add(lar.get(x));
        }
        CharArrayListTest.assertEquals((Object)lar, (Object)lar2);
        CharArrayListTest.assertFalse((boolean)lar.equals((Object)this));
        lar2.add('7');
        CharArrayListTest.assertFalse((boolean)lar.equals((Object)lar2));
    }

    @Test
    public void testForEach() {
        this.listOfFive.forEach(new CharProcedure(){
            int count;

            public boolean apply(char element) {
                Assert.assertFalse((this.count > 2 ? 1 : 0) != 0);
                ++this.count;
                return element != '\u0001';
            }
        });
    }

    @Test
    public void testGetQuick() {
        CharArrayList lar = new CharArrayList(10);
        lar.getQuick(1);
    }

    @Test
    public void testIndexOfFromTo() {
        int x = this.listOfFive.indexOfFromTo('\u0000', 2, 4);
        CharArrayListTest.assertEquals((long)-1L, (long)x);
        x = this.listOfFive.indexOfFromTo('\u0001', 0, 4);
        CharArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testLastIndexOfFromTo() {
        CharArrayList lar = new CharArrayList(10);
        lar.add('\u0001');
        lar.add('\u0002');
        lar.add('\u0003');
        lar.add('\u0002');
        lar.add('\u0001');
        CharArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOf('\u0002'));
        CharArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOfFromTo('\u0002', 2, 4));
        CharArrayListTest.assertEquals((long)-1L, (long)lar.lastIndexOf('o'));
    }

    @Test
    public void testPartFromTo() {
        AbstractCharList al = this.listOfFive.partFromTo(1, 2);
        CharArrayListTest.assertEquals((long)2L, (long)al.size());
        CharArrayListTest.assertEquals((long)1L, (long)al.get(0));
        CharArrayListTest.assertEquals((long)2L, (long)al.get(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPartFromToOOB() {
        this.listOfFive.partFromTo(10, 11);
    }

    @Test
    public void testRemoveAll() {
        int x;
        CharArrayList lar = new CharArrayList(1000);
        for (int x2 = 0; x2 < 128; ++x2) {
            lar.add((char)x2);
        }
        CharArrayList larOdd = new CharArrayList(500);
        for (x = 1; x < 128; x += 2) {
            larOdd.add((char)x);
        }
        lar.removeAll((AbstractCharList)larOdd);
        CharArrayListTest.assertEquals((long)64L, (long)lar.size());
        for (x = 0; x < lar.size(); ++x) {
            CharArrayListTest.assertEquals((long)(x * 2), (long)lar.get(x));
        }
    }

    @Test
    public void testReplaceFromToWith() {
        this.listOfFive.add('\u0005');
        CharArrayList lar = new CharArrayList();
        lar.add(',');
        lar.add('7');
        this.listOfFive.replaceFromToWithFromTo(2, 3, (AbstractCharList)lar, 0, 1);
        CharArrayListTest.assertEquals((long)0L, (long)this.listOfFive.get(0));
        CharArrayListTest.assertEquals((long)1L, (long)this.listOfFive.get(1));
        CharArrayListTest.assertEquals((long)44L, (long)this.listOfFive.get(2));
        CharArrayListTest.assertEquals((long)55L, (long)this.listOfFive.get(3));
        CharArrayListTest.assertEquals((long)4L, (long)this.listOfFive.get(4));
        CharArrayListTest.assertEquals((long)5L, (long)this.listOfFive.get(5));
    }

    @Test
    public void testRetainAllSmall() {
        CharArrayList lar = new CharArrayList();
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        CharArrayList lar2 = new CharArrayList();
        lar2.add('\u0003');
        lar2.add('\u0004');
        CharArrayListTest.assertTrue((boolean)lar.retainAll((AbstractCharList)lar2));
        for (int x = 0; x < lar.size(); ++x) {
            char l = lar.get(x);
            CharArrayListTest.assertTrue((l == '\u0003' || l == '\u0004' ? 1 : 0) != 0);
        }
        CharArrayListTest.assertEquals((long)6L, (long)lar.size());
    }

    @Test
    public void testRetainAllSmaller() {
        int x;
        CharArrayList lar = new CharArrayList();
        lar.addAllOf(this.listOfFive);
        CharArrayList lar2 = new CharArrayList();
        for (x = 0; x < 1000; ++x) {
            lar2.add('\u0003');
            lar2.add('\u0004');
        }
        CharArrayListTest.assertTrue((boolean)lar.retainAll((AbstractCharList)lar2));
        for (x = 0; x < lar.size(); ++x) {
            char l = lar.get(x);
            CharArrayListTest.assertTrue((l == '\u0003' || l == '\u0004' ? 1 : 0) != 0);
        }
    }
}

