/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.AbstractIntList;
import org.apache.mahout.math.list.IntArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntArrayListTest
extends Assert {
    private IntArrayList emptyList;
    private IntArrayList listOfFive;

    @Before
    public void before() {
        this.emptyList = new IntArrayList();
        this.listOfFive = new IntArrayList();
        for (int x = 0; x < 5; ++x) {
            this.listOfFive.add(x);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEmpty() {
        this.emptyList.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setEmpty() {
        this.emptyList.set(1, 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void beforeInsertInvalidRange() {
        this.emptyList.beforeInsert(1, 0);
    }

    @Test
    public void testAdd() {
        int x;
        this.emptyList.add(12);
        IntArrayListTest.assertEquals((long)1L, (long)this.emptyList.size());
        for (x = 0; x < 1000; ++x) {
            this.emptyList.add(x % Integer.MAX_VALUE);
        }
        IntArrayListTest.assertEquals((long)1001L, (long)this.emptyList.size());
        IntArrayListTest.assertEquals((long)12L, (long)this.emptyList.get(0));
        for (x = 0; x < 1000; ++x) {
            IntArrayListTest.assertEquals((long)(x % Integer.MAX_VALUE), (long)this.emptyList.get(x + 1));
        }
    }

    @Test
    public void testBinarySearch() {
        int x = this.listOfFive.binarySearchFromTo(0, 2, 4);
        IntArrayListTest.assertEquals((long)-3L, (long)x);
        x = this.listOfFive.binarySearchFromTo(1, 0, 4);
        IntArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testClone() {
        IntArrayList l2 = this.listOfFive.copy();
        IntArrayListTest.assertNotSame((Object)this.listOfFive, (Object)l2);
        IntArrayListTest.assertEquals((Object)this.listOfFive, (Object)l2);
    }

    @Test
    public void testElements() {
        int[] l = new int[]{12, 24, 36, 48};
        IntArrayList lar = new IntArrayList(l);
        IntArrayListTest.assertEquals((long)4L, (long)lar.size());
        IntArrayListTest.assertSame((Object)l, (Object)lar.elements());
        int[] l2 = new int[]{3, 6, 9, 12};
        lar.elements(l2);
        IntArrayListTest.assertSame((Object)l2, (Object)lar.elements());
    }

    @Test
    public void testEquals() {
        int[] l = new int[]{12, 24, 36, 48};
        IntArrayList lar = new IntArrayList(l);
        IntArrayList lar2 = new IntArrayList();
        for (int x = 0; x < lar.size(); ++x) {
            lar2.add(lar.get(x));
        }
        IntArrayListTest.assertEquals((Object)lar, (Object)lar2);
        IntArrayListTest.assertFalse((boolean)lar.equals((Object)this));
        lar2.add(55);
        IntArrayListTest.assertFalse((boolean)lar.equals((Object)lar2));
    }

    @Test
    public void testForEach() {
        this.listOfFive.forEach(new IntProcedure(){
            int count;

            public boolean apply(int element) {
                Assert.assertFalse((this.count > 2 ? 1 : 0) != 0);
                ++this.count;
                return element != 1;
            }
        });
    }

    @Test
    public void testGetQuick() {
        IntArrayList lar = new IntArrayList(10);
        lar.getQuick(1);
    }

    @Test
    public void testIndexOfFromTo() {
        int x = this.listOfFive.indexOfFromTo(0, 2, 4);
        IntArrayListTest.assertEquals((long)-1L, (long)x);
        x = this.listOfFive.indexOfFromTo(1, 0, 4);
        IntArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testLastIndexOfFromTo() {
        IntArrayList lar = new IntArrayList(10);
        lar.add(1);
        lar.add(2);
        lar.add(3);
        lar.add(2);
        lar.add(1);
        IntArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOf(2));
        IntArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOfFromTo(2, 2, 4));
        IntArrayListTest.assertEquals((long)-1L, (long)lar.lastIndexOf(111));
    }

    @Test
    public void testPartFromTo() {
        AbstractIntList al = this.listOfFive.partFromTo(1, 2);
        IntArrayListTest.assertEquals((long)2L, (long)al.size());
        IntArrayListTest.assertEquals((long)1L, (long)al.get(0));
        IntArrayListTest.assertEquals((long)2L, (long)al.get(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPartFromToOOB() {
        this.listOfFive.partFromTo(10, 11);
    }

    @Test
    public void testRemoveAll() {
        int x;
        IntArrayList lar = new IntArrayList(1000);
        for (int x2 = 0; x2 < 128; ++x2) {
            lar.add(x2);
        }
        IntArrayList larOdd = new IntArrayList(500);
        for (x = 1; x < 128; x += 2) {
            larOdd.add(x);
        }
        lar.removeAll((AbstractIntList)larOdd);
        IntArrayListTest.assertEquals((long)64L, (long)lar.size());
        for (x = 0; x < lar.size(); ++x) {
            IntArrayListTest.assertEquals((long)(x * 2), (long)lar.get(x));
        }
    }

    @Test
    public void testReplaceFromToWith() {
        this.listOfFive.add(5);
        IntArrayList lar = new IntArrayList();
        lar.add(44);
        lar.add(55);
        this.listOfFive.replaceFromToWithFromTo(2, 3, (AbstractIntList)lar, 0, 1);
        IntArrayListTest.assertEquals((long)0L, (long)this.listOfFive.get(0));
        IntArrayListTest.assertEquals((long)1L, (long)this.listOfFive.get(1));
        IntArrayListTest.assertEquals((long)44L, (long)this.listOfFive.get(2));
        IntArrayListTest.assertEquals((long)55L, (long)this.listOfFive.get(3));
        IntArrayListTest.assertEquals((long)4L, (long)this.listOfFive.get(4));
        IntArrayListTest.assertEquals((long)5L, (long)this.listOfFive.get(5));
    }

    @Test
    public void testRetainAllSmall() {
        IntArrayList lar = new IntArrayList();
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        IntArrayList lar2 = new IntArrayList();
        lar2.add(3);
        lar2.add(4);
        IntArrayListTest.assertTrue((boolean)lar.retainAll((AbstractIntList)lar2));
        for (int x = 0; x < lar.size(); ++x) {
            int l = lar.get(x);
            IntArrayListTest.assertTrue((l == 3 || l == 4 ? 1 : 0) != 0);
        }
        IntArrayListTest.assertEquals((long)6L, (long)lar.size());
    }

    @Test
    public void testRetainAllSmaller() {
        int x;
        IntArrayList lar = new IntArrayList();
        lar.addAllOf(this.listOfFive);
        IntArrayList lar2 = new IntArrayList();
        for (x = 0; x < 1000; ++x) {
            lar2.add(3);
            lar2.add(4);
        }
        IntArrayListTest.assertTrue((boolean)lar.retainAll((AbstractIntList)lar2));
        for (x = 0; x < lar.size(); ++x) {
            int l = lar.get(x);
            IntArrayListTest.assertTrue((l == 3 || l == 4 ? 1 : 0) != 0);
        }
    }
}

