/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteByteProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.map.OpenByteByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteByteHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        OpenByteByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteByteHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenByteByteHashMapTest.assertEquals((double)0.0, (double)map.get((byte)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        OpenByteByteHashMap map2 = (OpenByteByteHashMap)map.clone();
        map.clear();
        OpenByteByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        OpenByteByteHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteByteHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        OpenByteByteHashMapTest.assertTrue((boolean)map.containsValue((byte)22));
        OpenByteByteHashMapTest.assertFalse((boolean)map.containsValue((byte)23));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        map.put((byte)13, (byte)24);
        map.put((byte)14, (byte)25);
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteByteHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        map.put((byte)13, (byte)24);
        map.put((byte)14, (byte)25);
        map.removeKey((byte)13);
        map.forEachPair(new ByteByteProcedure(){

            public boolean apply(byte first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteByteHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteByteHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenByteByteHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteByteHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenByteByteHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteByteHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ByteByteProcedure(){
            int count = 0;

            public boolean apply(byte first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        OpenByteByteHashMapTest.assertEquals((long)22L, (long)map.get((byte)11));
        OpenByteByteHashMapTest.assertEquals((long)0L, (long)map.get((byte)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        map.put((byte)13, (byte)24);
        map.put((byte)14, (byte)25);
        map.adjustOrPutValue((byte)11, (byte)1, (byte)3);
        OpenByteByteHashMapTest.assertEquals((long)25L, (long)map.get((byte)11));
        map.adjustOrPutValue((byte)15, (byte)1, (byte)3);
        OpenByteByteHashMapTest.assertEquals((long)1L, (long)map.get((byte)15));
    }

    @Test
    public void testKeys() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)22);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteByteHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        map.put((byte)13, (byte)24);
        map.put((byte)14, (byte)25);
        map.removeKey((byte)13);
        map.pairsMatching(new ByteByteProcedure(){

            public boolean apply(byte first, byte second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenByteByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteByteHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteByteHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteByteHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenByteByteHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        map.put((byte)13, (byte)24);
        map.put((byte)14, (byte)25);
        map.removeKey((byte)13);
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenByteByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenByteByteHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenByteByteHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenByteByteHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        OpenByteByteHashMap map2 = (OpenByteByteHashMap)map.copy();
        map.clear();
        OpenByteByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        map.put((byte)13, (byte)24);
        map.put((byte)14, (byte)25);
        map.removeKey((byte)13);
        OpenByteByteHashMap map2 = (OpenByteByteHashMap)map.copy();
        OpenByteByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)22);
        map.put((byte)12, (byte)23);
        map.put((byte)13, (byte)24);
        map.put((byte)14, (byte)25);
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteByteHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteByteHashMap map = new OpenByteByteHashMap();
        map.put((byte)11, (byte)100);
        map.put((byte)12, (byte)70);
        map.put((byte)13, (byte)30);
        map.put((byte)14, (byte)3);
        ByteArrayList keys = new ByteArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteByteHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenByteByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteByteHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenByteByteHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteByteHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenByteByteHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteByteHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenByteByteHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteByteHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenByteByteHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteByteHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenByteByteHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteByteHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenByteByteHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteByteHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        byte v;

        Pair(byte k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

