/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteFloatProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenByteFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteFloatHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        OpenByteFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteFloatHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenByteFloatHashMapTest.assertEquals((double)0.0, (double)map.get((byte)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        OpenByteFloatHashMap map2 = (OpenByteFloatHashMap)map.clone();
        map.clear();
        OpenByteFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        OpenByteFloatHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteFloatHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        OpenByteFloatHashMapTest.assertTrue((boolean)map.containsValue(22.0f));
        OpenByteFloatHashMapTest.assertFalse((boolean)map.containsValue(23.0f));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        map.put((byte)13, 24.0f);
        map.put((byte)14, 25.0f);
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteFloatHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        map.put((byte)13, 24.0f);
        map.put((byte)14, 25.0f);
        map.removeKey((byte)13);
        map.forEachPair(new ByteFloatProcedure(){

            public boolean apply(byte first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteFloatHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteFloatHashMapTest.assertEquals((float)22.0f, (float)((Pair)pairs.get((int)0)).v, (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteFloatHashMapTest.assertEquals((float)23.0f, (float)((Pair)pairs.get((int)1)).v, (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteFloatHashMapTest.assertEquals((float)25.0f, (float)((Pair)pairs.get((int)2)).v, (float)1.0E-6f);
        pairs.clear();
        map.forEachPair(new ByteFloatProcedure(){
            int count = 0;

            public boolean apply(byte first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        OpenByteFloatHashMapTest.assertEquals((float)22.0f, (float)map.get((byte)11), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((float)0.0f, (float)map.get((byte)0), (float)1.0E-6f);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        map.put((byte)13, 24.0f);
        map.put((byte)14, 25.0f);
        map.adjustOrPutValue((byte)11, 1.0f, 3.0f);
        OpenByteFloatHashMapTest.assertEquals((float)25.0f, (float)map.get((byte)11), (float)1.0E-6f);
        map.adjustOrPutValue((byte)15, 1.0f, 3.0f);
        OpenByteFloatHashMapTest.assertEquals((float)1.0f, (float)map.get((byte)15), (float)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 22.0f);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteFloatHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        map.put((byte)13, 24.0f);
        map.put((byte)14, 25.0f);
        map.removeKey((byte)13);
        map.pairsMatching(new ByteFloatProcedure(){

            public boolean apply(byte first, float second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenByteFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteFloatHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteFloatHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteFloatHashMapTest.assertEquals((float)23.0f, (float)valueList.get(0), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((float)25.0f, (float)valueList.get(1), (float)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        map.put((byte)13, 24.0f);
        map.put((byte)14, 25.0f);
        map.removeKey((byte)13);
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenByteFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenByteFloatHashMapTest.assertEquals((float)22.0f, (float)values.get(0), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((float)23.0f, (float)values.get(1), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((float)25.0f, (float)values.get(2), (float)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        OpenByteFloatHashMap map2 = (OpenByteFloatHashMap)map.copy();
        map.clear();
        OpenByteFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        map.put((byte)13, 24.0f);
        map.put((byte)14, 25.0f);
        map.removeKey((byte)13);
        OpenByteFloatHashMap map2 = (OpenByteFloatHashMap)map.copy();
        OpenByteFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 22.0f);
        map.put((byte)12, 23.0f);
        map.put((byte)13, 24.0f);
        map.put((byte)14, 25.0f);
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteFloatHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteFloatHashMap map = new OpenByteFloatHashMap();
        map.put((byte)11, 100.0f);
        map.put((byte)12, 70.0f);
        map.put((byte)13, 30.0f);
        map.put((byte)14, 3.0f);
        ByteArrayList keys = new ByteArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(0), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(1), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(2), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(3), (float)1.0E-6f);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenByteFloatHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(3), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(2), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(1), (float)1.0E-6f);
        OpenByteFloatHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(0), (float)1.0E-6f);
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        float v;

        Pair(byte k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

