/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteIntProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenByteIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteIntHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        OpenByteIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteIntHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenByteIntHashMapTest.assertEquals((double)0.0, (double)map.get((byte)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        OpenByteIntHashMap map2 = (OpenByteIntHashMap)map.clone();
        map.clear();
        OpenByteIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        OpenByteIntHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteIntHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        OpenByteIntHashMapTest.assertTrue((boolean)map.containsValue(22));
        OpenByteIntHashMapTest.assertFalse((boolean)map.containsValue(23));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        map.put((byte)13, 24);
        map.put((byte)14, 25);
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteIntHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        map.put((byte)13, 24);
        map.put((byte)14, 25);
        map.removeKey((byte)13);
        map.forEachPair(new ByteIntProcedure(){

            public boolean apply(byte first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteIntHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteIntHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenByteIntHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteIntHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenByteIntHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteIntHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ByteIntProcedure(){
            int count = 0;

            public boolean apply(byte first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        OpenByteIntHashMapTest.assertEquals((long)22L, (long)map.get((byte)11));
        OpenByteIntHashMapTest.assertEquals((long)0L, (long)map.get((byte)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        map.put((byte)13, 24);
        map.put((byte)14, 25);
        map.adjustOrPutValue((byte)11, 1, 3);
        OpenByteIntHashMapTest.assertEquals((long)25L, (long)map.get((byte)11));
        map.adjustOrPutValue((byte)15, 1, 3);
        OpenByteIntHashMapTest.assertEquals((long)1L, (long)map.get((byte)15));
    }

    @Test
    public void testKeys() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 22);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteIntHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        map.put((byte)13, 24);
        map.put((byte)14, 25);
        map.removeKey((byte)13);
        map.pairsMatching(new ByteIntProcedure(){

            public boolean apply(byte first, int second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenByteIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteIntHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteIntHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteIntHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenByteIntHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        map.put((byte)13, 24);
        map.put((byte)14, 25);
        map.removeKey((byte)13);
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenByteIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenByteIntHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenByteIntHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenByteIntHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        OpenByteIntHashMap map2 = (OpenByteIntHashMap)map.copy();
        map.clear();
        OpenByteIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        map.put((byte)13, 24);
        map.put((byte)14, 25);
        map.removeKey((byte)13);
        OpenByteIntHashMap map2 = (OpenByteIntHashMap)map.copy();
        OpenByteIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 22);
        map.put((byte)12, 23);
        map.put((byte)13, 24);
        map.put((byte)14, 25);
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteIntHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteIntHashMap map = new OpenByteIntHashMap();
        map.put((byte)11, 100);
        map.put((byte)12, 70);
        map.put((byte)13, 30);
        map.put((byte)14, 3);
        ByteArrayList keys = new ByteArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteIntHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenByteIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteIntHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenByteIntHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteIntHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenByteIntHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteIntHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenByteIntHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteIntHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenByteIntHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteIntHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenByteIntHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteIntHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenByteIntHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteIntHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        int v;

        Pair(byte k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

