/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleCharProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenDoubleCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleCharHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        OpenDoubleCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleCharHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenDoubleCharHashMapTest.assertEquals((double)0.0, (double)map.get(11.0), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        OpenDoubleCharHashMap map2 = (OpenDoubleCharHashMap)map.clone();
        map.clear();
        OpenDoubleCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        OpenDoubleCharHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleCharHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        OpenDoubleCharHashMapTest.assertTrue((boolean)map.containsValue('\u0016'));
        OpenDoubleCharHashMapTest.assertFalse((boolean)map.containsValue('\u0017'));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        map.put(13.0, '\u0018');
        map.put(14.0, '\u0019');
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleCharHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        map.put(13.0, '\u0018');
        map.put(14.0, '\u0019');
        map.removeKey(13.0);
        map.forEachPair(new DoubleCharProcedure(){

            public boolean apply(double first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleCharHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenDoubleCharHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenDoubleCharHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new DoubleCharProcedure(){
            int count = 0;

            public boolean apply(double first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        OpenDoubleCharHashMapTest.assertEquals((long)22L, (long)map.get(11.0));
        OpenDoubleCharHashMapTest.assertEquals((long)0L, (long)map.get(0.0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        map.put(13.0, '\u0018');
        map.put(14.0, '\u0019');
        map.adjustOrPutValue(11.0, '\u0001', '\u0003');
        OpenDoubleCharHashMapTest.assertEquals((long)25L, (long)map.get(11.0));
        map.adjustOrPutValue(15.0, '\u0001', '\u0003');
        OpenDoubleCharHashMapTest.assertEquals((long)1L, (long)map.get(15.0));
    }

    @Test
    public void testKeys() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0016');
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleCharHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleCharHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        map.put(13.0, '\u0018');
        map.put(14.0, '\u0019');
        map.removeKey(13.0);
        map.pairsMatching(new DoubleCharProcedure(){

            public boolean apply(double first, char second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenDoubleCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleCharHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenDoubleCharHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        map.put(13.0, '\u0018');
        map.put(14.0, '\u0019');
        map.removeKey(13.0);
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenDoubleCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenDoubleCharHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenDoubleCharHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenDoubleCharHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        OpenDoubleCharHashMap map2 = (OpenDoubleCharHashMap)map.copy();
        map.clear();
        OpenDoubleCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        map.put(13.0, '\u0018');
        map.put(14.0, '\u0019');
        map.removeKey(13.0);
        OpenDoubleCharHashMap map2 = (OpenDoubleCharHashMap)map.copy();
        OpenDoubleCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, '\u0016');
        map.put(12.0, '\u0017');
        map.put(13.0, '\u0018');
        map.put(14.0, '\u0019');
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleCharHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleCharHashMap map = new OpenDoubleCharHashMap();
        map.put(11.0, 'd');
        map.put(12.0, 'F');
        map.put(13.0, '\u001e');
        map.put(14.0, '\u0003');
        DoubleArrayList keys = new DoubleArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleCharHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenDoubleCharHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenDoubleCharHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenDoubleCharHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenDoubleCharHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenDoubleCharHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenDoubleCharHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenDoubleCharHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleCharHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        char v;

        Pair(double k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

