/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.function.DoubleShortProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenDoubleShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleShortHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        OpenDoubleShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleShortHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenDoubleShortHashMapTest.assertEquals((double)0.0, (double)map.get(11.0), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        OpenDoubleShortHashMap map2 = (OpenDoubleShortHashMap)map.clone();
        map.clear();
        OpenDoubleShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        OpenDoubleShortHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleShortHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        OpenDoubleShortHashMapTest.assertTrue((boolean)map.containsValue((short)22));
        OpenDoubleShortHashMapTest.assertFalse((boolean)map.containsValue((short)23));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        map.put(13.0, (short)24);
        map.put(14.0, (short)25);
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleShortHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        map.put(13.0, (short)24);
        map.put(14.0, (short)25);
        map.removeKey(13.0);
        map.forEachPair(new DoubleShortProcedure(){

            public boolean apply(double first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleShortHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenDoubleShortHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenDoubleShortHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new DoubleShortProcedure(){
            int count = 0;

            public boolean apply(double first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        OpenDoubleShortHashMapTest.assertEquals((long)22L, (long)map.get(11.0));
        OpenDoubleShortHashMapTest.assertEquals((long)0L, (long)map.get(0.0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        map.put(13.0, (short)24);
        map.put(14.0, (short)25);
        map.adjustOrPutValue(11.0, (short)1, (short)3);
        OpenDoubleShortHashMapTest.assertEquals((long)25L, (long)map.get(11.0));
        map.adjustOrPutValue(15.0, (short)1, (short)3);
        OpenDoubleShortHashMapTest.assertEquals((long)1L, (long)map.get(15.0));
    }

    @Test
    public void testKeys() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)22);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleShortHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleShortHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        map.put(13.0, (short)24);
        map.put(14.0, (short)25);
        map.removeKey(13.0);
        map.pairsMatching(new DoubleShortProcedure(){

            public boolean apply(double first, short second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenDoubleShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleShortHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenDoubleShortHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        map.put(13.0, (short)24);
        map.put(14.0, (short)25);
        map.removeKey(13.0);
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenDoubleShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenDoubleShortHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenDoubleShortHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenDoubleShortHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        OpenDoubleShortHashMap map2 = (OpenDoubleShortHashMap)map.copy();
        map.clear();
        OpenDoubleShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        map.put(13.0, (short)24);
        map.put(14.0, (short)25);
        map.removeKey(13.0);
        OpenDoubleShortHashMap map2 = (OpenDoubleShortHashMap)map.copy();
        OpenDoubleShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)22);
        map.put(12.0, (short)23);
        map.put(13.0, (short)24);
        map.put(14.0, (short)25);
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleShortHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleShortHashMap map = new OpenDoubleShortHashMap();
        map.put(11.0, (short)100);
        map.put(12.0, (short)70);
        map.put(13.0, (short)30);
        map.put(14.0, (short)3);
        DoubleArrayList keys = new DoubleArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleShortHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenDoubleShortHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenDoubleShortHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenDoubleShortHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenDoubleShortHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenDoubleShortHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenDoubleShortHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenDoubleShortHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleShortHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        short v;

        Pair(double k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

